#include "IKS01A2.h"


IKS01A2::IKS01A2(I2C *i2c)
{
    lsm = new LSM6DSLSensor(i2c,LSM6DSL_ACC_GYRO_I2C_ADDRESS_HIGH);
    Acc = new LSM303AGR_ACC_Sensor(i2c);
    Mag = new LSM303AGR_MAG_Sensor(i2c);

    HumTemp = new HTS221Sensor (i2c);  
    PressTemp = new LPS22HBSensor(i2c);  
    //init
    init();
}

uint32_t IKS01A2::isConnect()
{
    uint32_t temp_value = CONNECT;
    uint8_t temp_id;
    lsm->ReadID(&temp_id);
    if(temp_id != LSM6DSL_ACC_GYRO_WHO_AM_I)
        temp_value |= LSM6D_NOT_CONNECT;
    Acc->ReadID(&temp_id);
    if(temp_id != LSM303AGR_ACC_WHO_AM_I)
        temp_value |= LSM303_ACC_NOT_CONNECT;
    Mag->ReadID(&temp_id);
    if(temp_id != LSM303AGR_MAG_WHO_AM_I)
        temp_value |= LSM303_MAG_NOT_CONNECT;
    HumTemp->ReadID(&temp_id);
    if(temp_id != HTS221_WHO_AM_I_VAL)
        temp_value |= HTS221_NOT_CONNECT;
    PressTemp->ReadID(&temp_id);
    if(temp_id != LPS22HB_WHO_AM_I_VAL)
        temp_value |= LPS22_NOT_CONNECT;
    return temp_value;
}

void IKS01A2::init()
{
    lsm->Enable_X();  
    lsm->Enable_G(); 
     //
    Acc->Enable();
    Mag->Enable(); 

    HumTemp->Enable();
    PressTemp->Enable();
}

void IKS01A2::getXAxesLSM6DSL(int32_t *arg)
{
    lsm->Get_X_Axes(arg);
}

void IKS01A2::getGAxesLSM6DSL(int32_t *arg)
{
    lsm->Get_G_Axes(arg);
}

void IKS01A2::getDataLSM303AGR(int32_t *arg)
{
     Acc->GetAxes(arg);
}

void IKS01A2::getDataLSM303MAG(int32_t *arg)
{
    Mag->GetAxes(arg);
}

void IKS01A2::GetHumidity(float *arg)
{
    HumTemp->GetHumidity(arg);
}

void IKS01A2::GetTemperatureHTS221(float *arg)
{
    HumTemp->GetTemperature(arg);
}

void IKS01A2::GetPressure(float *arg)
{
    PressTemp->GetPressure(arg); 
}

void IKS01A2::GetTemperatureLPS22HB(float *arg)
{
    PressTemp->GetTemperature(arg);
}


char IKS01A2::getIdLSM6DSL()
{
    uint8_t temp_id;
    lsm->ReadID(&temp_id);
    return temp_id;
}

char IKS01A2::getIdLSM303AGR()
{
    uint8_t temp_id;
    Acc->ReadID(&temp_id);
    return temp_id;
}

char IKS01A2::getIdLSM303MAG()
{
    uint8_t temp_id;
    Mag->ReadID(&temp_id);
    return temp_id;
}

char IKS01A2::getIdHTS221()
{
    uint8_t temp_id;
    HumTemp->ReadID(&temp_id);
    return temp_id;
}

char IKS01A2::getIdLPS22HB()
{
    uint8_t temp_id;
    PressTemp->ReadID(&temp_id);
    return temp_id;
}
