#ifndef IKS01A2_H
#define IKS01A2_H

#include "mbed.h"
#include "LSM6DSLSensor.h"
#include "LSM303AGR_ACC_Sensor.h"
#include "LSM303AGR_MAG_Sensor.h"
#include "HTS221Sensor.h"
#include "LPS22HBSensor.h"

#define CONNECT                 0
#define LSM6D_NOT_CONNECT       (0x1 << 0)
#define LSM303_ACC_NOT_CONNECT  (0x1 << 1)
#define LSM303_MAG_NOT_CONNECT  (0x1 << 2)
#define HTS221_NOT_CONNECT      (0x1 << 3)
#define LPS22_NOT_CONNECT       (0x1 << 4)

class IKS01A2 {

public:
    /**
     * @brief Construct .
     */
    IKS01A2(I2C *i2c);

    /**
     * @brief Test the sensor is connectd.
     * @return 0 success.
     */
    uint32_t isConnect();


    /**
     * @brief Get ACC data from LSM6DSL.
     * @param arg [out]
     */
    void getXAxesLSM6DSL(int32_t *arg);

    /**
     * @brief Get MAG data from LSM6DSL.
     * @param arg [out]
     */
    void getGAxesLSM6DSL(int32_t *arg);

    /**
     * @brief Get data from LSM303AGR.
     * @param arg[out]
     */
    void getDataLSM303AGR(int32_t *arg);

    /**
     * @brief Get data from LSM303MAG.
     * @param arg [description]
     */
    void getDataLSM303MAG(int32_t *arg);

    /**
     * @brief Get Humidity from HTS221.
     * @param arg [out]
     */
    void GetHumidity(float *arg);

    /**
     * @brief Get Temperature from HTS221.
     * @param arg [description]
     */
    void GetTemperatureHTS221(float *arg);

    /**
     * @brief Get press data from LPS22HB.
     * @param arg [out]
     */
    void GetPressure(float *arg);

    /**
     * @brief Get Temperature data from LPS22HB.
     * @param arg [description]
     */
    void GetTemperatureLPS22HB(float *arg);

    /**
     * @brief Get LSM6DSL Id.
     * @return [id
     * 3]
     */
    char getIdLSM6DSL();

    /**
     * @brief Get LSM303AGR Id.
     * @return [id]
     */
    char getIdLSM303AGR();

    /**
     * @brief Get LSM303MAG Id.
     * @return [id]
     */
    char getIdLSM303MAG();

    /**
     * @brief Get HTS221 id.
     */
    char getIdHTS221();

    /**
     * @brief Get LPS22HB id.
     * @return [description]
     */
    char getIdLPS22HB();
private:
    /**
     * @brief Init all of sensor.
     */
    void init();

    LSM6DSLSensor *lsm ;
    LSM303AGR_ACC_Sensor *Acc ;
    LSM303AGR_MAG_Sensor *Mag ;
    HTS221Sensor *HumTemp ;  
    LPS22HBSensor *PressTemp ;  
};


#endif
