#include "mbed.h"
#include "HTU21D.h"





#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif


#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif





/*macros for HTU21D*/
#define DISPLAY_HTU21D_STRING "HTU21D Sensor:"
#define DISPLAY_HTU21D_STRING_HIGH 16
#define DISPLAY_HTU21D_TEM_VALUE_STRING  "Temperature value:"
#define DISPLAY_HTU21D_TEM_VALUE_STRING_HIGH  32
#define DISPLAY_HTU21D_TEM_VALUE_HIGH  48
#define DISPLAY_HTU21D_HUM_VALUE_STRING  "Humidity value:"
#define DISPLAY_HTU21D_HUM_VALUE_STRING_HIGH  64
#define DISPLAY_HTU21D_HUM_VALUE_HIGH  80



static void displayForHTU21D(LCD &lcd,HTU21D &htu)
{
#ifdef TEST_LCD
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);
  lcd.drawString(0,DISPLAY_HTU21D_STRING_HIGH,DISPLAY_HTU21D_STRING,RED);
  lcd.drawString(0,DISPLAY_HTU21D_TEM_VALUE_STRING_HIGH,DISPLAY_HTU21D_TEM_VALUE_STRING,RED);
  lcd.drawString(0,DISPLAY_HTU21D_HUM_VALUE_STRING_HIGH,DISPLAY_HTU21D_HUM_VALUE_STRING,RED);
#endif
}

static void handleLCDForHTU21D(LCD &lcd,HTU21D &htu)
{
  char temp_buffer[50];
  int temperature,humidity;
  while(1)
  {
    temperature = htu.sample_ctemp();
    humidity = htu.sample_humid();
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d",temperature);
    printf("HTU21D temperature = %d \r\n",temperature);
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_HTU21D_TEM_VALUE_HIGH,temp_buffer,RED);
#endif
    memset(temp_buffer,0,sizeof(temp_buffer));
    sprintf(temp_buffer,"%d",humidity);
    printf("HTU21D humidity = %d \r\n",humidity);
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_HTU21D_HUM_VALUE_HIGH,temp_buffer,RED);
#endif
    wait_ms(1000);
#ifdef TEST_LCD
    lcd.clearScreenArea(0,DISPLAY_HTU21D_TEM_VALUE_HIGH,WHITE);
    lcd.clearScreenArea(0,DISPLAY_HTU21D_HUM_VALUE_HIGH,WHITE);
#endif
  }
}

int main()
{
  HTU21D htu;
  printf("%s\r\n",DISPLAY_TMPM_STRING);
#ifdef TEST_LCD
  tft.init();
#endif
  displayForHTU21D(tft,htu);
  handleLCDForHTU21D(tft,htu);
  while(1)
  {
  }
}