#include "mbed.h"
#include "MAG3110.h"
#include "FXOS8700Q.h"
#include "MMA8652.h"
#include "FXLS8471Q.h"
#include "FXAS21000.h"
#include "MPL3115A2.h"




#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif


int main()
{
    FXLS8471Q acc1(D11, D12, D13, D10);
    MMA8652   acc2(D14, D15);
    FXOS8700Q_acc combo_acc(D14, D15, FXOS8700CQ_SLAVE_ADDR0);
    FXOS8700Q_mag combo_mag(D14, D15, FXOS8700CQ_SLAVE_ADDR0);
    MAG3110   mag2(D14, D15);
    FXAS21000 gyro(D14, D15);
    MPL3115A2 wigo_sensor1(D14, D15, MPL3115A2_DEFAULT_ADDRESS,(PinName)0,(PinName)0);
    float acc_data[3], gyro_data[3],sensor_data[2];
    MotionSensorDataUnits adata;
    MotionSensorDataUnits mdata;
    int16_t acc_raw[3];
    printf("%s\r\n",DISPLAY_TMPM_STRING);
    combo_acc.enable();
    combo_mag.enable();
    mag2.enable();
    wigo_sensor1.Barometric_Mode();
    wigo_sensor1.Oversample_Ratio( OVERSAMPLE_RATIO_32);
     printf("FXLS8471 Acc   = 0x%x\r\n", acc1.getWhoAmI());
     printf("MMA8652 Acc    = 0x%x\r\n", acc2.getWhoAmI());
     printf("FXOS8700 Combo = 0x%x\r\n", combo_acc.whoAmI());
     printf("MAG3110 Mag    = 0x%x\r\n", mag2.whoAmI());
     printf("FXAS21000 Gyro = 0x%x\r\n", gyro.getWhoAmI());
     printf("MPL3115A2 = 0x%x \r\n",wigo_sensor1.getDeviceID());    
     while(1) {
        acc1.ReadXYZ(acc_data);
        acc1.ReadXYZraw(acc_raw);
        printf("FXLS8471 Acc:   X:%6.3f Y:%6.3f Z:%6.3f (Raw X:%4d Y:%4d Z:%4d)\r\n", acc_data[0], acc_data[1], acc_data[2], acc_raw[0], acc_raw[1], acc_raw[2]);

        acc2.ReadXYZ(acc_data);
        acc2.ReadXYZraw(acc_raw);
        printf("MMA8652 Acc:    X:%6.3f Y:%6.3f Z:%6.3f (Raw X:%4d Y:%4d Z:%4d)\r\n", acc_data[0], acc_data[1], acc_data[2], acc_raw[0], acc_raw[1], acc_raw[2]);

        combo_acc.getAxis(adata);
        printf("FXOS8700 Acc:   X:%6.3f Y:%6.3f Z:%6.3f\r\n", adata.x, adata.y, adata.z);
        
        combo_mag.getAxis(mdata);
        printf("FXOS8700 Mag:   X:%6.2f Y:%6.2f Z:%6.2f\r\n", mdata.x, mdata.y, mdata.z);

        mag2.getAxis(mdata);
        printf("MAG3110 Mag:    X:%6.2f Y:%6.2f Z:%6.2f\r\n", mdata.x, mdata.y, mdata.z);

        gyro.ReadXYZ(gyro_data);
        printf("FXAS21000 Gyro: X:%6.2f Y:%6.2f Z:%6.2f\r\n", gyro_data[0], gyro_data[1], gyro_data[2]);
        
        
        if ( wigo_sensor1.isDataAvailable()) 
        {
            if(wigo_sensor1.getMode() == BAROMETRIC_MODE)
            {
              wigo_sensor1.getAllData( &sensor_data[0]);
              printf("Pressure: %f Temperature: %f\r\n", sensor_data[0], sensor_data[1]);
              wigo_sensor1.Altimeter_Mode();
            }
            else
            {
              wigo_sensor1.getAllData( &sensor_data[0]);
              printf("Altitude: %f Temperature: %f\r\n", sensor_data[0], sensor_data[1]);
              wigo_sensor1.Barometric_Mode();
            }
        }
        printf("\r\n");
        wait_ms(1000);
     }
}