#include "mbed.h"
#include "bh1790glc.h"


#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif


#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"

/*macro for BH1790GLC*/
#define DISPLAY_BH1790GLC_STRING_ID "BH1790GLC ID:"
#define DISPLAY_BH1790GLC_STRING_ID_HIGH  16
#define DISPLAY_BH1790GLC_VALUE_STRING "BH1790GLC value:"
#define DISPLAY_BH1790GLC_VALUE_STRING_HIGH 32
#define DISPLAY_BH1790GLC_VALUE_HIGH 48


static void displayForBH1790GLC(LCD &lcd,BH1790GLC &bh1790glc)
{
#ifdef TEST_LCD
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);
  displayId(lcd,DISPLAY_BH1790GLC_STRING_ID,sizeof(DISPLAY_BH1790GLC_STRING_ID),DISPLAY_BH1790GLC_STRING_ID_HIGH,bh1790glc.getDeviceID());
  lcd.drawString(0,DISPLAY_BH1790GLC_VALUE_STRING_HIGH,DISPLAY_BH1790GLC_VALUE_STRING,RED);
#endif
}

static void handleLCDForBH1790GLC(LCD &lcd,BH1790GLC &bh1790glc)
{
  char temp_buffer[50];
  uint16_t data[2];
  while(1)
  {
    memset(temp_buffer,0,sizeof(temp_buffer));
#ifdef TEST_LCD
    bh1790glc.getresults(data);
#endif
    sprintf(temp_buffer,"%d,%d",data[0],data[1]);
    printf("BH1790GLC data = %d,%d\r\n",data[0],data[1]);
#ifdef TEST_LCD
    lcd.drawString(0,DISPLAY_BH1790GLC_VALUE_HIGH,temp_buffer,RED);
#endif
    wait_ms(1000);
#ifdef TEST_LCD
    lcd.clearScreenArea(0,DISPLAY_BH1790GLC_VALUE_HIGH,WHITE);
#endif
  }
}




int main()
{
    uint16_t data[2];
    I2C i2c(I2C_SDA, I2C_SCL);
    RegisterWriter i2c_rw(i2c);
    BH1790GLC bh1790glc(i2c_rw);
    printf("%s\r\n",DISPLAY_TMPM_STRING);
    printf("BH1790GLC Decide Id = 0x%x \r\n",bh1790glc.getDeviceID());
    bh1790glc.set_default_on();
#ifdef TEST_LCD
    tft.init();
#endif
    displayForBH1790GLC(tft,bh1790glc);
    handleLCDForBH1790GLC(tft,bh1790glc);
    while(1)
    {
    }
}