/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
 
#include "mbed.h"
#include "MMA8491.h"
 
 

#ifdef TEST_LCD
LCD tft(LCD_SPI_CS,LCD_SPI_DC, LCD_MOSI_PIN, LCD_MISO_PIN, LCD_SPI_CL_PIN,LCD_BL_PIN);
#else
#define LCD int
LCD tft;
#endif


#if __TT_M3HQ__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M3HQ"
#endif


#if __TT_M4G9__
#define DISPLAY_TMPM_STRING "Welcome to Thundersoft TT_M4G9"
#endif

/*macros for A8491 board*/
#define DISPLAY_A8491_STRING "A8491 board:"
#define DISPLAY_A8491_STRING_HIGH 16
#define DISPLAY_A8491_VALUE_STRING  "A8491 value:"
#define DISPLAY_A8491_VALUE_STRING_HIGH  32
#define DISPLAY_A8491_VALUE_HIGH  48



static void displayForA8491(LCD &lcd)
{
#ifdef TEST_LCD
  lcd.drawString(0,0,DISPLAY_TMPM_STRING,RED);
  lcd.drawString(0,DISPLAY_A8491_STRING_HIGH,DISPLAY_A8491_STRING,RED);
  lcd.drawString(0,DISPLAY_A8491_VALUE_STRING_HIGH,DISPLAY_A8491_VALUE_STRING,RED);
#endif
}

static void handleLCDForA8491(LCD &lcd,MMA8491 &accel)
{
  float accel_data[3]; float accel_rms=0.0;
  char temp_buffer[50];
  while(1)
  {
#ifdef TEST_LCD
    accel.acquire_MMA8491_data_g(accel_data);
    sprintf(temp_buffer,"%4.2f,%4.2f,%4.2f",accel_data[0],accel_data[1],accel_data[2]);
    lcd.drawString(0,DISPLAY_A8491_VALUE_HIGH,temp_buffer,RED);
#endif
    printf("%4.2f,%4.2f,%4.2f,\r\n",accel_data[0],accel_data[1],accel_data[2]);
#ifdef TEST_LCD
    wait_ms(1000);
    lcd.clearScreenArea(0,DISPLAY_A8491_VALUE_HIGH,WHITE);
#endif
  }
}



int main()
{    
    MMA8491 accel(D14,D15,A1);
    float accel_data[3]; float accel_rms=0.0;
#ifdef TEST_LCD
    tft.init();
    displayForA8491(tft);
#endif   
    printf("%s\r\n",DISPLAY_TMPM_STRING);
    handleLCDForA8491(tft,accel);
    while(1)
    {       
    }
}
