#include "mbed.h"
#include "stm32f769i_discovery_lcd.h"
#include "stm32f769i_discovery.h"
#include "stm32f769i_discovery_ts.h"

TS_StateTypeDef  TS_State = {0};

uint32_t Xsize = 0;
uint32_t Ysize = 0;

Serial pc(USBTX, USBRX); // tx, rx
 
AnalogIn Ain(A0);   //Read Analog input
AnalogIn Ain1(A1); //Read Analog input 1
AnalogIn Ain2(A2); //Read Analog input 2
DigitalIn user(USER_BUTTON); //Read user button
DigitalOut myLED(LED1); //Toggle LED on if button is pressed

float ADCdata = 0;
float vibdata = 0;

float datain[10000];
float datain1[10000];
int button_state=0;

/*

    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_GRAY);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    
*/

int main()
{
    uint16_t x1, y1;
    
    BSP_LCD_Init();
    // BSP_LCD_InitEx(LCD_ORIENTATION_PORTRAIT);
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(0);

    /* Touchscreen initialization */
    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) == TS_ERROR) {
        printf("BSP_TS_Init error\n");
}
    Xsize = BSP_LCD_GetXSize();
    Ysize = BSP_LCD_GetYSize();
    BSP_LCD_Clear(LCD_COLOR_ORANGE);
    BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
    BSP_LCD_SetFont(&Font24);
    
    BSP_LCD_DisplayStringAt(40,75 , (uint8_t *)"BD", CENTER_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0, 250, (uint8_t *)"ThrillSeeker Fistula Health Monitor", CENTER_MODE);
    
    HAL_Delay(2000);
    
        BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Detection Ready: Place armband on Fistula Arm", CENTER_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_DisplayStringAt(0, 250, (uint8_t *)"Press OK when ready", CENTER_MODE);
    
    BSP_LCD_FillRect(437, 375, 75, 75);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(72, 400, (uint8_t *)" OK", CENTER_MODE);
    
   
    while (1) {
            
           BSP_TS_GetState(&TS_State);
           if (TS_State.touchDetected) { 
           x1 = TS_State.touchX[0];
            y1 = TS_State.touchY[0];
            pc.printf("Touch Detected x=%d y=%d\n", x1, y1);
              BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
            BSP_LCD_FillCircle(x1, y1, 2); 
            
            if ((475<x1<525) && (350<y1<400))
            button_state=1;
            //else button_state=0;
            HAL_Delay(100);}
   //button_state=user;
   if(button_state==1)
   {
 ADCdata=Ain;

 vibdata = (Ain1 - Ain2) ;
    button_state=0;
    x1=0;
    y1=0;
         
        
        for(int count1 = 0; count1 < 10000; count1++)
      { datain1[count1]=vibdata;
            if (datain1[count1]>vibdata)
            vibdata=datain1[count1];
            else vibdata=vibdata;
            
 }
 
  for(int count = 0; count < 10000; count++)
      { datain[count]=ADCdata;
            if (datain[count]>ADCdata)
            ADCdata=datain[count];
            else ADCdata=ADCdata;
 }
 
        /*     pc.printf("\n Button State: %d", button_state);
          pc.printf("\n Microphone Data: %f ",ADCdata);
          pc.printf("\n Vibration Data: %f", vibdata);*/
          
 vibdata=abs(vibdata);
            pc.printf("\n Vibration Data: %f", vibdata);
                     
 if (vibdata<0.1) {
     
     vibdata=0; 
    BSP_LCD_Clear(LCD_COLOR_ORANGE);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_SetBackColor(LCD_COLOR_ORANGE); 
     BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Fistula is Normal", CENTER_MODE);
     //HAL_Delay(200);
     
     }
     
     else if ((0.1 <= vibdata) && (vibdata <0.2)) {
     vibdata=0; 
    BSP_LCD_Clear(LCD_COLOR_ORANGE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
          BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Potential Occlusion to occur soon.", CENTER_MODE);
          BSP_LCD_DisplayStringAt(0, 200, (uint8_t *)"Fistula health at 75%", CENTER_MODE);
     //   HAL_Delay(5000);

          }
         
         else if (vibdata>= 0.2){
      vibdata=0; 
    BSP_LCD_Clear(LCD_COLOR_RED);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_RED);
            BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Abnormality detected: Please Consult Physician", CENTER_MODE);
        //     HAL_Delay(5000);

             }
 vibdata=0;
 /*    if (ADCdata<0.202) {
     
     ADCdata=0;   
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);
        BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Fistula is Normal", CENTER_MODE);
     HAL_Delay(20000);
     
     }
     
     else if ((0.202 <= ADCdata) && (ADCdata <0.85)) {
     ADCdata=0; 
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);

          BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Potential Occlusion to occur soon.", CENTER_MODE);
          BSP_LCD_DisplayStringAt(0, 200, (uint8_t *)"Fistula health at xx%", CENTER_MODE);
        HAL_Delay(20000);
          }
         
         else if (ADCdata>= 0.85){
      ADCdata=0; 
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);

            BSP_LCD_DisplayStringAt(0, 150, (uint8_t *)"Abnormality detected: Please Consult Physician", CENTER_MODE);
             HAL_Delay(20000);
            
             }*/
            
 }    
}
}