#include "mbed.h"
#include "stm32f769i_discovery_lcd.h"
/*#include "stlogo.h"*/

uint32_t Xsize = 0;
uint32_t Ysize = 0;

Serial pc(USBTX, USBRX); // tx, rx
 
AnalogIn Ain(A0);   //Read Analog input
AnalogOut Aout(A1); //Write Analog output 
DigitalOut Dout(D0); //Write PWM output
float ADCdata;

/*

    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_GRAY);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    
*/

int main()
{
    BSP_LCD_Init();
    // BSP_LCD_InitEx(LCD_ORIENTATION_PORTRAIT);
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(0);

    Xsize = BSP_LCD_GetXSize();
    Ysize = BSP_LCD_GetYSize();
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);
    
    BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"ThrillSeeker Fistula Health Monitor", CENTER_MODE);
    
    HAL_Delay(2000);
    pc.printf("ThrillSeeker First Demo Run\n Press any key to continue\n");
  //  wait (3.0);
    
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Detection Ready: Place armband on Fistula Arm", CENTER_MODE);
    HAL_Delay(2000);
    

    while (1) {
       
       /* LCD_Show_Feature(LCD_Feature); remove when using sd card or bitmap*/
        ADCdata=Ain;
        PwmOut PWMout(D6); // output off PWM pin D6/PWM11
        
        //HAL_Delay(3000);
        
      
     if (ADCdata<0.2) {
     Dout=0; //set Digital output pin = 0
     
        int i=0;
        while(i<100) {
        Aout = (0.01+(sin(2*3.14159*i/100.0)))/2.0;
                i++;  }
     
     PWMout.period_ms(10);   //PERIOD in mili second   --FREQUENCY
     PWMout.write(0.1f);   // Duty cycle  10% 
       
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);
        BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Fistula is Normal", CENTER_MODE);
     HAL_Delay(1000);
     pc.printf("%f \n\r",ADCdata);
     printf(" Normal Fistula \n");
     
     }
     else if ((0.2 <= ADCdata) && (ADCdata <0.85)) {
         Dout=1;
         
         Aout = 0.05;
            
         PWMout.period_ms(10);   
         PWMout.write(0.5f);   // Duty cycle  50% 
         
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);

          BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"Potential Occlusion to occur soon. Fistula health at xx%", CENTER_MODE);
        HAL_Delay(1000);
         
     pc.printf("%f \n\r",ADCdata);
         printf(" 50percent Healthy Fistula \n");
     
         }
         
         else if (ADCdata>= 0.85){
             Dout = 1;
             
             Aout = 0.1;
                
             PWMout.period_ms(10);   
             PWMout.write(0.9f);   // Duty cycle  90% 
             
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_GRAY);
    BSP_LCD_SetFont(&Font24);

            BSP_LCD_DisplayStringAt(0, 10, (uint8_t *)"Abnormality detected: Please Consult Physician", CENTER_MODE);
             HAL_Delay(1000);
               pc.printf("%f \n\r",ADCdata);
             printf(" Abnormal Fistula \n");
             
             }
             
    }
}
