#include "mbed.h"
#include "SDFileSystem.h"
#include "rtos.h"
#define freq 1


#define dur_sec 20

Serial pc(USBTX, USBRX);
Serial gsm(D1, D0); //tx,rx
DigitalOut dtr(D2);
DigitalOut pwr_key(D3);
DigitalOut gsm_rst(D7);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
AnalogIn AC_input(A0);
AnalogIn DC_input(A2);
AnalogIn TC_RLY(A3);
AnalogIn TC_50(A4);
AnalogIn TC_33(A5);


union Data
    {
    unsigned short datai[50000];
    char datac[100000];
    };
union Data ACdata;
union Data DCdata;


unsigned short TC33temp;
unsigned short TC50temp;
unsigned short TCRLtemp;

char sitename[100] ="MODZ";
char filename[100] = "";
char filepath[100] = "";
char timestamp[100]="";
char timestampold[100]="";
char main_dir[100] ="";
char hour_dir[100] ="";
char pathAC[100]   ="";
char pathDC[100]   ="";
char pathTC[100]   ="";
char filenameAC[100]   ="";
char filenameDC[100]   ="";
char clk_response[100] ="";
//char command[100] ="";
//char result[100] ="";
//char FTP_File_Name[100] ="";
//char FTPPUT_File_Name[100] ="";
//char FTP_Path_Name[100] ="";
//char allfilename[100];
//char mainfilename[100][100];
int m=0,mfinal;
int date, month, year, hour, minute, second, temp = 0;
int c,i;
int ns;
unsigned long var = 0;
unsigned long currentMillis = 0;
uint8_t x=0,z=0,  answer=0;

time_t previous;
float tempC;
uint32_t dataLength = dur_sec*freq*1000;
osThreadId tid1,tid2,tid3,tid4,tid5,tid6;
char ftpget[100];
//char ftpfilenameac[100];
//char ftppathac[100];
int reset_time=120; //mins
int gsmerr=0;

//--------------------------------------------------------------------------------------------------//
//                  Module reset                                                                    //
//--------------------------------------------------------------------------------------------------//
void reset_mod()
{
    //pc.printf("\r\nresetting module\n\n\n\r\n");
    NVIC_SystemReset();     
}
//--------------------------------------------------------------------------------------------------//
//                  Send AT Command (1 response)                                                    //
//--------------------------------------------------------------------------------------------------//
int8_t sendATcommand(char* ATcommand, char* expected_answer, unsigned int timeout, bool clk_flag)
{
    uint8_t x=0,answer=0;                                                                           //x=0 and answer=0, if not put, AT+CCLK?\r is not executed
    char response[100];
    memset(response, '\0', 100);                                                                    // Initialize the string
    wait_ms(100);
    while( gsm.readable() > 0) gsm.getc();                                                          // Clean the input buffer
    gsm.printf("%s \r", ATcommand);                                                                 // Send the AT command 
    x = 0;
    previous = time(NULL);
    do                                                                                              // this loop waits for the answer
    { 
        if(gsm.readable() != 0)
        {    
            response[x] = gsm.getc();                                                               // if there are data in the UART input buffer, reads it and checks for the asnwer 
            pc.putc(response[x]);
            x++;
            if (strstr(response, expected_answer) != NULL)                                          // check if the desired answer  is in the response of the module
            {
                answer = 1;
            } 
        }
    }
    while((answer == 0) && ((time(NULL) - previous) < timeout));                                    // Waits for the asnwer with time out
    //pc.printf("%s \r\n",response);  
    if(clk_flag == 1)
    {
        sprintf(timestamp,response);                                                                //copies response to timestamp for further processing    }
    }
    return answer;
}
//--------------------------------------------------------------------------------------------------//
//                  Send AT Command (2 response)                                                    //
//--------------------------------------------------------------------------------------------------//
int8_t sendATcommand2(char* ATcommand, char* expected_answer1,char* expected_answer2, unsigned int timeout)
{
    uint8_t x=0,  answer=0;
    char response[100];
    time_t previous;
    memset(response, '\0', 100);                                                                    // Initialize the string
    Thread::wait(100);
    while( gsm.readable() != 0) gsm.getc();                                                         // Clean the input buffer
    gsm.printf("%s \r", ATcommand);                                                                 // Send the AT command 
    x = 0;
    previous = time(NULL);
    do                                                                                              // this loop waits for the answer
    { 
        if(gsm.readable() != 0)                                                                     // if there are data in the UART input buffer, reads it and checks for the asnwer
        {
            response[x] = gsm.getc();
            pc.putc(response[x]);
            sprintf(ftpget,"%s",response);
            x++;
            if (strstr(response, expected_answer1) != NULL)                                         // check if the desired answer 1 is in the response of the module
            {
                answer = 1;
            }
            if (strstr(response, expected_answer2) != NULL)                                         // check if the desired answer 2 is in the response of the module
            {
                answer = 2;
                break;
            }
        }
    }
    while((answer == 0) && ((time(NULL) - previous) < timeout));                                    // Waits for the asnwer with time out
    return answer;
}

//--------------------------------------------------------------------------------------------------//
//                  Getting File Directories and names                                              //
//--------------------------------------------------------------------------------------------------//   
void GetFileDir()
{
    int attempt_cnt=0;
    char month_dir[100]="";
    char date_dir[100] ="";
    sendATcommand("AT+CCLK?\r", "OK", 5,1);  
    //sprintf(response,timestamp);
    x=20;
    year = 10*(timestamp[x+1]-48) + (timestamp[x+2]-48);
    while(year!=14&&year!=15)
    {
        sendATcommand("AT+CCLK?\r", "OK", 5,1);  
        //sprintf(response,timestamp);
        year = 10*(timestamp[x+1]-48) + (timestamp[x+2]-48);
        //pc.printf("\r\ncurrent timestamp %s\r\n",timestamp);
        attempt_cnt++;
        if(attempt_cnt>4) break; 
    }
    if(year==14||year==15)
    {
        if(timestamp!=timestampold)
        {
            sprintf(timestampold,timestamp);
            //pc.printf("\r\nold time stamp is%s\r\n",timestampold);
            month = (timestamp[x+4]-48)*10+(timestamp[x+5]-48);
            date = (timestamp[x+7]-48)*10+(timestamp[x+8]-48);
            hour = (timestamp[x+10]-48)*10+(timestamp[x+11]-48);
            minute = (timestamp[x+13]-48)*10+(timestamp[x+14]-48);
            second = (timestamp[x+16]-48)*10+(timestamp[x+17]-48); 
            
            sprintf(main_dir,"/sd/%s",sitename);
            sprintf(month_dir,"%s/%s%02d%02d",main_dir,sitename,year,month);
            sprintf(date_dir,"%s/%s%02d%02d%02d",month_dir,sitename,year,month,date);
            sprintf(hour_dir,"%s/%s%02d%02d%02d%02d",date_dir,sitename,year,month,date,hour);
            sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02d",hour_dir,sitename,year,month,date,hour,minute,second);
            sprintf(filename,"%s%02d%02d%02d%02d%02d%02d",sitename,year,month,date,hour,minute,second);
            gsmerr=0;
            mkdir(main_dir,0777);
            mkdir(month_dir,0777);
            mkdir(date_dir,0777);
            mkdir(hour_dir,0777);
        }
        else
        {
            sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02dErr%03d",hour_dir,sitename,year,month,date,hour,minute,second,gsmerr);
            sprintf(filename,"%s%02d%02d%02d%02d%02d%02dErr%03d",sitename,year,month,date,hour,minute,second,gsmerr);
            gsmerr++;
        }
    }
    else
    {
        sprintf(timestamp,timestampold);
        sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02dErr%03d",hour_dir,sitename,year,month,date,hour,minute,second,gsmerr);
        sprintf(filename,"%s%02d%02d%02d%02d%02d%02dErr%03d",sitename,year,month,date,hour,minute,second,gsmerr);
        gsmerr++;
    }
}   

//--------------------------------------------------------------------------------------------------//
//                  Temperature Sampling                                                            //
//--------------------------------------------------------------------------------------------------//
void temp_val()
{   
    TC33temp=TC_33.read_u16();
    TC50temp=TC_50.read_u16();
    TCRLtemp=TC_RLY.read_u16();
    
}

//--------------------------------------------------------------------------------------------------//
//                  AC-DC Sampling                                                                  //
//--------------------------------------------------------------------------------------------------//
void calculate_ADC()
{
    Timer t;
    unsigned long j=0;
    //pc.printf("\n\rStarting Reading \n\r");
    t.start();
    while(j<dataLength)
    {        
        if((int)(t.read()*100*freq*1000)%100 == 0)
        {
            ACdata.datai[j] = AC_input.read_u16();
            DCdata.datai[j] = DC_input.read_u16();
            ++j;
        }
    }
    t.stop();
    //pc.printf("Time Taken %f \n\r", t.read());
    t.reset();
    //pc.printf("Total Samples %d\r\n",j);
}
//--------------------------------------------------------------------------------------------------//
//                  Storage                                                                         //
//--------------------------------------------------------------------------------------------------//
void store(void const *args)
{
    tid3 = osThreadGetId();
    //osThreadSetPriority(tid3, osPriorityHigh);
    while(true)
    {
        osSignalWait(0x1, osWaitForever);
        //pc.printf("\r\n%d is value of ns\r\n",ns);
        switch (ns)
        {
            case 0:
                GetFileDir();
                sprintf(filenameAC,"%sAC.txt",filename);
                sprintf(pathAC,"%sAC.txt",filepath);
                pc.printf("\r\nFilename-AC\t%s", pathAC);
                FILE *fp = fopen(pathAC, "w");
                if(fp == NULL)
                {
                    //pc.printf("Could not open file for write\n\r");
                    reset_mod();
                }
                else
                {
                    for(unsigned long k=0; k<dataLength; ++k)
                    {
                        if (k%4==0)
                        {
                            fprintf(fp,"\n\n");
                        }
                        fprintf(fp, "%c%c", ACdata.datac[2*k],ACdata.datac[2*k+1]);
                    }
                    fprintf(fp, "EOF");
                    fclose(fp);
                }
                sprintf(filenameDC,"%sDC.txt",filename);
                sprintf(pathDC,"%sDC.txt",filepath);
                pc.printf("\r\nFilename-DC\t%s", pathDC);
                FILE *fp1 = fopen(pathDC, "w");
                if(fp1 == NULL)
                {
                    //pc.printf("Could not open file for write\n\r");
                    reset_mod();
                }
                else
                {
                    for(unsigned long k=0; k<dataLength; ++k)
                    {
                        if (k%4==0)
                        {
                            fprintf(fp,"\n\n");
                        }
                        fprintf(fp1, "%c%c", DCdata.datac[2*k],DCdata.datac[2*k+1]);
                    }
                    fprintf(fp1, "EOF");
                }
                fclose(fp1);
                sprintf(pathTC,"%sTC.txt",hour_dir);
                //pc.printf("\r\nFilename-TC\t%s", pathTC);    
                FILE *fp2 = fopen(pathTC, "a");
                if(fp2 == NULL)
                {
                    //pc.printf("Could not open file for write\n\r");
                    //reset_mod();
                }
                else
                {
                    for(unsigned long k=0; k<28; ++k)
                    {
                        fprintf(fp2, "\r\n3.3V-%d C",TC33temp);  
                        fprintf(fp2, "\r\n5.0V-%d C",TC50temp);  
                        fprintf(fp2, "\r\nRlay-%d C",TCRLtemp);           
                        fprintf(fp2, ",");
                    }
                }
                fclose(fp2);     
                osSignalSet(tid6, 0x1);
                break;

            case 1:
                sprintf(pathTC,"%sTC.txt",hour_dir);
                //pc.printf("\r\nFilename-TC\t%s", pathTC);    
                FILE *fp4 = fopen(pathTC, "a");
                if(fp4 == NULL)
                {
                    //pc.printf("Could not open file for write\n\r");
                    //reset_mod();
                }
                //fprintf(fp3, "\r\n20%d/%d%d/%d%d-%d%d:%d%d:%d%d",year,montht,monthu,datet,dateu,hourt,houru,minutet,minuteu,secondt,secondu);
                else
                {
                    for(unsigned long k=0; k<28; ++k)
                    {
                        fprintf(fp4, "\r\n3.3V-%d C",TC33temp);
                        fprintf(fp4, "\r\n5.0V-%d C",TC50temp);
                        fprintf(fp4, "\r\nRlay-%d C",TCRLtemp);
                        fprintf(fp4, ",");
                    }
                }
                fclose(fp4);
                break;
        }
    }
}

//--------------------------------------------------------------------------------------------------//
//                 Sampling Function                                                                //
//--------------------------------------------------------------------------------------------------//

void sampling(void const *args)
{
    int smplngcnt=0;
    tid1 = osThreadGetId();
    //osThreadSetPriority(tid1, osPriorityRealtime);
    //pc.printf("\r\nstarted sampling thread\r\n");
    while(true)
    {
    if(smplngcnt%16==0)
        {
            pc.printf("AC sampling attempt");
            if(smplngcnt>27) smplngcnt=0;
            smplngcnt++;
            ns=0;
            calculate_ADC();
            temp_val();
            smplngcnt++;
            osSignalSet(tid3, 0x1);
        }
    else
        {
            ns=1;
            temp_val();
            smplngcnt++;
        }
    Thread::wait(10000);
    
    }
}

//--------------------------------------------------------------------------------------------------//
//                 Read Filenames from SD Card                                                      //
//--------------------------------------------------------------------------------------------------//
/*void read_ALLFILENames(void const *args)
{
        
        while (true)
        {
                  
        tid5 = osThreadGetId();
        osSignalWait(0x1, osWaitForever);
        //osThreadSetPriority(tid5, osPriorityBelowNormal);
        pc.printf("\r\n reading names");
        
        FILE *fp = fopen("/sd/AllFileName.txt", "r");
        while(!feof(fp))
        {
        //pc.putc("%c", fgetc(fp));
        fscanf(fp,"%s",allfilename);
        //pc.printf("\r\n%s",allfilename);
        sprintf(mainfilename[m],allfilename);
        m++;
        //pc.printf("\n\r value of m=%d\n\r",m);
    
        }
        fclose(fp);
        mfinal=m;
        //pc.printf("\n\rvalue of m=%d\r\n",mfinal);
        for(m=0;m<mfinal/3;m++)
        {
        //pc.printf("\r\n%dpath\t%s",m,mainfilename[3*m]);
        sprintf(ftppathac,"%s",mainfilename[3*m]);
        //pc.printf("\r\n%dpath\t%s",m,mainfilename[3*m+1]);
        sprintf(ftpfilenameac, "%s", filename[3*m+1]);
        //pc.printf("\r\n%dpath\t%s",m,mainfilename[3*m+2]);
        }
        }
}*/

//--------------------------------------------------------------------------------------------------//
//                 GSM Initialization                                                               //
//--------------------------------------------------------------------------------------------------//
void gsm_init()
{
    int cnt = 0;
    while((sendATcommand("AT+CREG?", "+CREG: 1,1", 5, 0) || sendATcommand("AT+CREG?", "+CREG: 1,5", 5, 0)) == 0)
    {
        if(sendATcommand("AT+CREG=1", "+CREG:1", 5, 0))
        {
            pc.printf("creg is 1");
            return;
        }
        else if(sendATcommand("AT+CREG=1", "+CREG:5", 5, 0))
        {
        pc.printf("creg is 5");
        return;
        }
        //wait(2);
        ++cnt;
        //pc.printf("%d", cnt);
        if(cnt == 4)
        {
            pc.printf("GSM registration failed");
            return;
        }
    }
}
//--------------------------------------------------------------------------------------------------//
//                 FTP Connect function                                                             //
//--------------------------------------------------------------------------------------------------//
bool ftp_connect()
{  
    int ftp_connect_attempt=0;
    int ftp_close_attempt=0; 
   // char command[50];
   // char result[50];
    if(sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5, 0))
    {
    }
    else 
    {
        while(!sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5, 0))
        {
            sendATcommand("AT+SAPBR=0,1","OK",5, 0);
            ftp_close_attempt++;
            if(ftp_close_attempt>3)
            {
                return 0;
            }
        }
    }
    while(sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5, 0))
    {
        sendATcommand("AT+SAPBR=1,1", "OK", 5, 0);
        ftp_connect_attempt++;
        if(ftp_connect_attempt>6)
        {
            return 0;
        }    //Connect to Bearer 1
    }
    
    sendATcommand("AT+FTPTYPE=\"I\"", "OK", 5, 0);
    sendATcommand("AT+FTPSERV=\"ftp.panchsheel.biz\"", "OK", 10, 0);
    sendATcommand("AT+FTPUN=\"hardware@panchsheel.biz\"", "OK\r", 10, 0);
    if(sendATcommand("AT+FTPPW=\"DAStest123\"", "OK\r", 10, 0)) return 1;
    else return 0;
    //sprintf(command,"%s%s", "AT+FTPPUTNAME=",filename);
    //sprintf(result,"%s", "OK");
    //sendATcommand(command,result, 5);       
    //sendATcommand("AT+FTPPUTPATH=\"/\"", "OK", 5);
    //if(sendATcommand("AT+FTPPUT=1\r", "+FTPPUT:1,1", 10)) return 1;
    //else return 0;
}

//--------------------------------------------------------------------------------------------------//
//                 FTP Send Function                                                                //
//--------------------------------------------------------------------------------------------------//

void ftp_put(bool ftp_type)
{  
    char ftpfilename[30]="";
    char ftpfilepath[100]="";
    if (ftp_type ==0)
    {
    sprintf(ftpfilename,"%s",filenameAC);
   // pc.printf("\n %s",ftpfilename);
   // pc.printf("\n %p",ftpfilename);
    sprintf(ftpfilepath,"%s",pathAC);

    }
    else if (ftp_type ==1)
    {
    sprintf(ftpfilename,"%s",filenameDC);
    sprintf(ftpfilepath,"%s",pathDC);
    }
    pc.printf("\r\nftp_put attempt\n\r");
    char command1[40];
    char result1[20];
    // pc.printf("\n %p",ftpfilename);
    sprintf(command1,"%s\"%s\"", "AT+FTPPUTNAME=", ftpfilename);
  //  pc.printf("\n %p",command1);
    sprintf(result1,"%s", "OK");
    for(int putname_attempt=0; putname_attempt<3;putname_attempt++)
    {
      //  pc.printf("\n %p",ftpfilename);
        if(sendATcommand(command1,result1, 10, 0))
        {
          //  pc.printf("\n %p",ftpfilename);
            sendATcommand("AT+FTPPUTPATH=\"/Trial//\"", "OK", 5, 0);
            //sendATcommand("AT+FTPPUT=1\r", "+FTPPUT:1,1", 10);
            //pc.printf("\r\n%s\r\n",ftpfilepath);
            //pc.printf("\r\n%s\r\n",ftpfilename); 
           // unsigned long int cnt=0;
            if(sendATcommand("AT+FTPPUT=1", "OK", 10, 0))
            {
                    pc.printf("in loop");
                    pc.printf("\n\r %s",ftpfilepath);
                    FILE *fp9 = fopen(ftpfilepath, "r");
                    if(fp9==NULL)return;
                    else
                    {
                        int trialcount=0;
                        int allowedtrials=5;
                        while(trialcount<allowedtrials)
                        {
                            if(sendATcommand("AT+FTPPUT=2,1000","+FTPPUT:2,1000", 10, 0))
                            {
                                trialcount=0;
                                for(int i=0; i<1000; i++)
                                {
                                    gsm.printf("%c", fgetc(fp9));
                                    
                                }
                                break;
                            }
                            else 
                            {
                                pc.printf("attempt %d failed",trialcount);
                                trialcount++;
                           }
                        }
                       
                        fclose(fp9);
                    }
                   
                    for(int ftp_close_attempt=0; ftp_close_attempt<5; ftp_close_attempt++)
                    {
                        if(sendATcommand("AT+FTPPUT=2,0", "OK", 5, 0)) 
                        {
                            ftp_close_attempt=6;
                        }
                    }
                    return;
                //}
               
            }
            return;
        }
    }
    pc.printf("\n\r %s\n\r","i am not able to send data");
}

//--------------------------------------------------------------------------------------------------//
//                 FTP Function Thread                                                              //
//--------------------------------------------------------------------------------------------------//

void FTP_Fun(void const *args)
{
    tid6 = osThreadGetId();
        
    while(true)
    {
        osSignalWait(0x1, osWaitForever);
        //osThreadSetPriority(tid6, osPriorityLow);
        
        if(ftp_connect())
        {
            //char ACfilename[100],DCfilename[100], TCfilename[100];
            //sprintf(ACfilename,"%sAC",filename);
            //sprintf(DCfilename,"%sDC",filename);
            //sprintf(TCfilename,"%s%02d%02d%02d%03dTC.txt",sitename,year,month,date,hour);
            ftp_put(0);
            ftp_put(1);
            //ftp_put(3,pathTC,TCfilename);
        }
    }
}
//--------------------------------------------------------------------------------------------------//
//                 Main Function                                                                    //
//--------------------------------------------------------------------------------------------------//
int main()
{
    //mkdir("/sd/strtup", 0777);
    gsm_rst=1;
    wait(5);
    //pc.printf("Hello\r\n");
    //gsm_init();
    //wait(2);
    gsm.baud(115200);
    pc.baud(115200);
    Thread thread1(sampling);
    Thread thread3(store);
    //Thread thread4(SDError);
    //Thread thread5(read_ALLFILENames);
    Thread thread6(FTP_Fun);
    while(true)
    {
        for (int f=0; f<reset_time; f++)//reset after 60 min
        {
            Thread::wait(60000);
        }
        reset_mod();       
    //osSignalSet(tid2, 0x1);
    }    
}