/*
* This file contains all the necessary settings for the IQS624 and this file can
* be changed from the GUI or edited here
* File:   IQS624_init.h
* Author: Azoteq
*/

#ifndef IQS624_INIT_H
#define IQS624_INIT_H

/* Change the Prox Sensor Settings */
/* Memory Map Position 0x40 - 0x49 */
#define PXS_SETTINGS_0                      0x01
#define PXS_SETTINGS_1                      0x02
#define PXS_SETTINGS_2                      0x5A
#define PXS_SETTINGS_3                      0x18
#define PXS_SETTINGS_4                      0xD0
#define PXS_SETTINGS_5                      0x00
#define PXS_SETTINGS_6                      0xE6
#define PXS_SETTINGS_7                      0x9A
#define PXS_SETTINGS_8                      0x81
#define PXS_SETTINGS_9                      0x05

/* Change the Prox UI Settings */
/* Memory Map Position 0x50 - 0x54 */
#define PXS_UI_SETTINGS_0                   0x14
#define PXS_UI_SETTINGS_1                   0x20
#define PXS_UI_SETTINGS_2                   0x14
#define PXS_UI_SETTINGS_3                   0x20
#define PXS_UI_SETTINGS_4                   0x28

/* Change the HALL Sensor Settings */
/* Memory Map Position 0x70 - 0x7A */
#define HALL_SETTINGS_0                     0x04
#define HALL_SETTINGS_1                     0x03
#define HALL_SETTINGS_2                     0x93
#define HALL_SETTINGS_3                     0x93
#define HALL_SETTINGS_4                     0xAC
#define HALL_SETTINGS_5                     0xA1
#define HALL_SETTINGS_6                     0x0A
#define HALL_SETTINGS_7                     0x09
#define HALL_SETTINGS_8                     0x46
#define HALL_SETTINGS_9                     0x70
#define HALL_SETTINGS_10                    0xE5

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD7 */
#define SYSTEM_SETTINGS                     0x08
#define ACTIVE_CHS                          0x3F
#define PMU_SETTINGS                        0x03
#define REPORT_RATES_TIMINGS_0              0x10
#define REPORT_RATES_TIMINGS_1              0x64
#define REPORT_RATES_TIMINGS_2              0x0A
#define REPORT_RATES_TIMINGS_3              0x14
#define REPORT_RATES_TIMINGS_4              0x07

#endif  /* IQS624_INIT_H */
