#include    "mbed.h"
#include    "DRV8830.h"
#include    "MotorMove.h"
#define SPEED_RATIO  1.0

//float vol_decel_ini[DECEL_SIZE] = {1,0.75,0.4,0.15,0.05,0};
float vol_decel_ini[DECEL_SIZE] = {-0.5,0,0,0,0,0};
float vol_accel_ini[ACCEL_SIZE] = {1,1,1,1,1,1};
//float vol_accel_ini[ACCEL_SIZE] = {0.2,0.4,0.6,0.8,.9,1.0};

void MotorMove::up_motor_set(int time_counter, float speed)
    {
        bflag_up   =1;
        bflag_down =0;
        start_time_count=time_counter;
        accel_count = 0;
        decel_count = 0;

        for (int i=0;i<ACCEL_SIZE;i++)
        {
             vol_accel[i] = -vol_accel_ini[i]*speed/SPEED_RATIO;
        }                

        for (int i=0;i<DECEL_SIZE;i++)
        {
             vol_decel[i] = -vol_decel_ini[i]*speed/SPEED_RATIO;
        }
    };

void MotorMove::down_motor_set(int time_counter, float speed)
    {
        bflag_up   =0;
        bflag_down =1;
        start_time_count=time_counter;
        accel_count = 0;
        decel_count = 0;

        for (int i=0;i<ACCEL_SIZE;i++)
        {
             vol_accel[i] = vol_accel_ini[i]*speed/SPEED_RATIO;
        }  
        
        for (int i=0;i<DECEL_SIZE;i++)
        {
             vol_decel[i] = vol_decel_ini[i]*speed/SPEED_RATIO;
        }
    };
    
    
float MotorMove::ReturnMotorVol(int time_counter,int bflag_downed, int bflag_upped)
    {
        float speed;
        int time;
        
        static int flag_up_stopping=0;
        static int flag_down_stopping=0;
        
        //Check flag for normal mode or brake mode
        //accel_count MODE

        
        if (bflag_up==1 && bflag_upped ==1)
        {
            flag_up_stopping=1;   
            //bflag_up==0;
        }
        else if (bflag_down==1 && bflag_downed ==1)
        {
           flag_down_stopping=1;
           //bflag_down=0;
        }


        if (bflag_up==1 && bflag_upped==0)
          {
                if (accel_count<(ACCEL_SIZE-1))
                {
                    speed = vol_accel[accel_count];
                    accel_count++;
                }
                else
                {
                    speed = vol_accel[ACCEL_SIZE-1];    
                }
          }
        else if(bflag_up==1 && bflag_upped==1)
           {
                    speed=vol_decel[0];
                    bflag_up=0;
           }
        else if (bflag_down==1 && bflag_downed==0)
          {
                if (accel_count<(ACCEL_SIZE-1))
                {
                    speed = vol_accel[accel_count];
                    accel_count++;
                }
                else
                {
                    speed = vol_accel[ACCEL_SIZE-1];    
                }
          }
        else if(bflag_down==1 && bflag_downed==1)
           {
                    speed=vol_decel[0];
                    bflag_down=0;
           }
        
        
        
         else
         {
             speed=0;
        }
        
        /*              
        if (bflag_up==1)
          {
            if  (flag_up_stopping==0)
            {
                if (accel_count<(ACCEL_SIZE-1))
                {
                    speed = vol_accel[accel_count];
                    accel_count++;
                }
                else
                {
                    speed = vol_accel[ACCEL_SIZE-1];    
                }
            }
            else if(flag_up_stopping==1)
            {
                if  (decel_count<=(DECEL_SIZE-1))
                {
                    speed = vol_decel[decel_count];
                    decel_count++;
                }
                else 
                {
                bflag_up=0;
                speed=0;
                flag_up_stopping=0;
                }
            }
         }
        else if (bflag_down==1)
          {
            if  (flag_down_stopping==0)
            {
                if (accel_count<(ACCEL_SIZE-1))
                {
                    speed = vol_accel[accel_count];
                    accel_count++;
                }
                else
                {
                    speed = vol_accel[ACCEL_SIZE-1];    
                }
            }
            else if(flag_down_stopping==1)
            {
                if  (decel_count<=(DECEL_SIZE-1))
                {
                    speed = vol_decel[decel_count];
                    decel_count++;
                }
                else 
                {
                bflag_down=0;
                speed=0;
                flag_down_stopping=0;
                }
            }
         }
         else
         {
             speed=0;
        }
        */
                         

        //move motor before push stopping switch 
        return speed;      
        
         
    };
    
  

