#include "mbed.h"
#include "ThingerEthernetClient.h"

DigitalOut redLed(LEDR);
DigitalOut greenLed(LEDG);
DigitalOut blueLed(LEDB);

void redLedCallback(pson& in){
    redLed = in ? false : true;
}

void greenLedCallback(pson& in){
    greenLed = in ? false : true;
}

void blueLedCallback(pson& in){
    blueLed = in ? false : true;
}

int main()
{
    ThingerEthernetClient thing("username", "device_id", "device_credential");

    thing["red_led"].set_input(redLedCallback);
    thing["green_led"].set_input(greenLedCallback);
    thing["blue_led"].set_input(blueLedCallback);
    
    while(true) {
        thing.handle();
    }
}
