#include "ThingerClient.h"
#include "EthernetInterface.h"
#include "TCPSocket.h"

class ThingerEthernetClient : public ThingerClient
{
private:
    EthernetInterface ethernet;
    TCPSocket socket;

public:
    ThingerEthernetClient(const char* user, const char* device, const char* device_credential) :
        ThingerClient(user, device, device_credential), connected_(false)
    {}

    virtual ~ThingerEthernetClient() {
    }

protected:

    virtual bool socket_start(const char* host, int port) {
        return socket.connect(host, port)==0;
    }

    virtual bool socket_stop() {
        return socket.close()==0;
    }

    virtual bool socket_connected() {
        return socket.is_connected();
    }

    virtual size_t socket_read(char* buffer, size_t size) {
        return socket.receive_all(buffer, size);
    }

    virtual size_t socket_write(char* buffer, size_t size) {
        return socket.send_all(buffer, size);
    }

    virtual size_t socket_available() {
        return socket.available();
    }

    virtual bool connect_network() {
        if(connected_) return true;
        ethernet.init();
        
#ifdef _DEBUG_
        printf("[NETWORK] Getting DHCP IP Address...\r\n");
#endif
        while(ethernet.connect()!=0) {
            wait(5);
            ethernet.disconnect();
            ethernet.init();
        }
#ifdef _DEBUG_
        printf("[NETWORK] Got Ip Address: %s\r\n", ethernet.getIPAddress());
#endif
        connected_ = true;
        return connected_;
    }

    virtual bool network_connected() {
        return connected_;
    }

private:
    bool connected_;
};

