// The MIT License (MIT)
//
// Copyright (c) 2015 THINGER LTD
// Author: alvarolb@gmail.com (Alvaro Luis Bustamante)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef THINGER_MAP_H
#define THINGER_MAP_H

#include <string.h>

template <class T>
class thinger_map {

public:
    thinger_map() : head_(NULL), last_(NULL) {

    }

    virtual ~thinger_map() {
    }

public:

    struct entry {
        entry(const char* key) : key_(key), next_(NULL){

        }

        const char* key_;
        struct entry * next_;
        T value_;
    };

private:

    entry * head_;
    entry * last_;

public:

    T& operator[](const char* key){
        entry * current = head_;
        while(current != NULL){
            if(strcmp(key, current->key_)==0){
                return current->value_;
            }
            current = current->next_;
        }
        // TODO replace with memory allocator for allowing static memory/dynamic memory
        current = new entry(key);

        if(head_==NULL) head_ = current;
        if(last_!=NULL) last_->next_ = current;
        last_ = current;
        return current->value_;
    }

    entry* begin(){
        return head_;
    }

    entry* end(){
        return last_;
    }

    bool empty()
    {
        return head_ == last_;
    }

    T* find(const char* key)
    {
        if(key==NULL) return NULL;
        entry * current = head_;
        while(current != NULL){
            if(strcmp(key, current->key_)==0){
                return &current->value_;
            }
            current = current->next_;
        }
        return NULL;
    }

};

#endif
