/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "LSM6DS33.h"

LSM6DS33 acc = LSM6DS33(I2C_SDA, I2C_SCL);

float axx;
float ayy; 
float azz;
float vx;
float vy;
float V;

int main()
{
    vx = 0;
    vy = 0;
    acc.begin();
    while (1) {
    acc.readAccel();
    axx = acc.ax; 
    ayy = acc.ay; 
    azz = acc.az; 
    vx = vx + axx*9.8*1/104;
    vy = vy + ayy*9.8*1/104;
    V = sqrt(vx*vx+vy*vy);
    
    printf("acceleration en V = %f\n", V);
    //printf("acceleration en y = %f\n", ayy);
    //printf("acceleration en z = %f\n", azz); 
    //wait(0.5);
}
}