  #include "mbed.h"
 

PwmOut moteur_cc_pwm(D10); 
DigitalOut Trig(D12);
InterruptIn reception(D11);

DigitalOut LED(LED1);
Serial pc(USBTX, USBRX);
Timer t;
double  distance ;

void front_montant()
{
    t.start();
}

void front_descendant()
{
    t.stop();
    double dist = 330*t.read()/2*1.06;
    distance = dist ;
    pc.printf("Distance = %f \r\n",330*t.read()/2*1.06);
    t.reset();

} 

int main() 
{
       t.reset();
       reception.rise(&front_montant);
       reception.fall(&front_descendant);
       double rc = 1;
       moteur_cc_pwm.period(0.001);
       moteur_cc_pwm.write(rc);

    while(1)
    {
        Trig = 0;
        Trig = 1;    
        if (distance<=0.10){ rc = 0;}
        if (distance<=0.20 && distance>0.10){ rc = 0.4;}
        if (distance<=0.40 && distance>0.20){ rc = 0.6;}
        if (distance<=0.50 && distance>0.40){ rc = 0.8;}
    //pc.printf("rapport cyclique = \r \n"); 
    //pc.scanf("%lf" ,&rc);
        pc.printf("Nouvelle valeur du rapport cyclique = %lf \r \n", rc);
        moteur_cc_pwm.write(rc);
        
    }
}