#include "LSM6DS33.h"
#include <stdio.h>    
#include <stdlib.h>


// Definition des variables de l'accéléromètre

LSM6DS33 acc = LSM6DS33(I2C_SDA, I2C_SCL);      //Déclarations des broches pour la communication en I2C

float axx0; // On définit la variable pour l'accélération initiale en x
float ayy0; // On définit la variable pour l'accélération initiale en y

float axx1; // On définit la variable pour l'accélération évoluant au cours du temps selon x
float ayy1; // On définit la variable pour l'accélération évoluant au cours du temps selon y

float vx0; // On définit la variable pour la vitesse initiale en x
float vy0; // On définit la variable pour la vitesse initiale en y

float vx; // On définit la variable pour la vitesse évoluant au cours du temps selon x
float vy; // On définit la variable pour la vitesse évoluant au cours du temps selon y
float V; // On définit la variable pour la norme de la vitesse.

float epsilonx; //  Variable utilisé pour l'initialisation, elle permet d'avoir la valeur de axx0 la plus proche possible de l'accélération initiale en x
float epsilony; //  Variable utilisé pour l'initialisation, elle permet d'avoir la valeur de ayy0 la plus proche possible de l'accélération initiale en y
// En effet, lors de la mesure de l'accélération initiale, on ne peut pas être certains que la première mesure faite par l'accéléromètre correspond 
// exactement à l'accélération intiale : il est possible qu'un léger décalage/rotation ait eu lieu, résultant à une accélération intiale erronée. 
// Par la suite, on explique la méthode utilisée pour résoudre ce problème

float tabax[5]; // Tableau des 5 dernières accélérations en x mesurées
float tabay[5]; // Tableau des 5 dernières accélérations en y mesurées
float tabvx[5]; // Tableau des 5 dernières vitesses en x mesurées
float tabvy[5]; // Tableau des 5 dernières vitesses en y mesurées

int k; // Variable d'incrémentation


int main()
{
    // On initialise les différentes variables qui évoluent : 
    k = 0; // l'entier k nous permettant d'indexer les mesures
    vx = 0; // la vitesse en x
    vy = 0; // la vitesse en y
    
    acc.begin(); // On démarre la lecture de l'accéléromètre 
    
    acc.readAccel(); // On lit les données de l'accéléromètre
    axx0 = acc.ax;  // On affecte à axx0 la première lecture par l'accéléromètre selon l'axe x
    ayy0 = acc.ay;  // On affecte à ayy0 la première lecture par l'accéléromètre selon l'axe y
    
    acc.readAccel(); // On lit de nouveau les valeurs sur l'accéléromètre et on les compare avec les valeurs précédentes
    epsilonx = acc.ax-axx0; // écart selon x entre la nouvelle accélération et l'ancienne accélértion
    epsilony = acc.ay-ayy0; // écart selon y entre la nouvelle accélération et l'ancienne accélértion
    
    while (1) {
        
    // Calibration nécessaire à vitesse nul (position immobile), l'accéleration est nulle
    // On calcule l'écart entre la valeur lue et la valeur initial (contenant le bruit)
    // On veut que l'accéleration qu'on mesure soit nul, pour cela, nous devons trouver axx0
    // le plus précisement possible ( à 10^-2). On pourra alors retrancher axx0 au futur valeur.
    // NB : D'autres méthodes sont possibles, par exemple faire la moyenne des n premières valeurs...
        while(abs(epsilonx)>0.001 or abs(epsilony)>0.001) 
        {
            axx0=axx0+epsilonx;
            ayy0=ayy0+epsilony;
            acc.readAccel();
            epsilonx = acc.ax-axx0;
            epsilony = acc.ay-ayy0;
            printf("epsilonx vaut : %f\n", epsilonx); 
            printf("epsilony vaut : %f\n", epsilony);
        }
        
    // Mesure de l'accélération en g (1g = 9,8 m/s^2) 
    acc.readAccel();
    axx1 = acc.ax-axx0;    // accélération en x mesurée auquel nous avons retranché l'accélération initial en x
    ayy1 = acc.ay-ayy0;    // accélération en y mesurée auquel nous avons retranché l'accélération initial en y 
    
    // Condition de seuil pour eviter de prendre en  compte le bruit
    if (abs(axx1) < 0.01) 
        {
        axx1 = 0; // On considère que c'est du bruit donc on le néglige
        }
    if (abs(ayy1) < 0.01) 
        {
        ayy1 = 0; // On considère que c'est du bruit donc on le néglige
        }
    // Calcul de la vitesse par intégration
    wait(0.0005);
    vx = vx + axx1*9.8*0.0005*1000; // l'accéleration est lue en g, on souhaite l'obtenir en m/s^2. Lors de l'intégration, on multiplie tout simplement
    vy = vy + ayy1*9.8*0.0005*1000; // par le temps d'intégration entre deux lectures.
    V = sqrt(vx*vx+vy*vy); // Calcul de la norme de la vitesse
    
    if (abs(vx)<0.001) //  On considère que si la vitesse mesurée est inférieur à 0.001 m/s résulte du bruit
    {                  //  Cette condition fixe notre sensibilité, ainsi toute vitesse inférieur à cette condition est tout simplement ignorée.
        vx=0;
        }
    if (abs(vy)<0.001)
    {
        vy=0;
        } 
    // Malgré tout, due au faite que l'accéleration n'est pas continue, nous n'arrivons pas à faire redescendre la vitesse à 0. 
    // (problème d'intégration de l'accéleration due à son échantillonnage)
    // Pour combler ce soucis, nous comparons les 5 dernières valeurs et considérons que si l'accélération ET la vitesse est inférieur à une certaines valeurs
    // alors, l'objet est bien immobile et on remet donc la vitesse à zéro. 
        if (k == 5) {k=0;}; 
        tabax[k] = axx1;
        tabay[k] = ayy1;
        tabvx[k] = vx;
        tabvy[k] = vy;
        if ( tabax[0]<0.1 && tabax[1]<0.1  && tabax[2]<0.1 && tabax[3]<0.1 && tabax[4]<0.1 && tabvx[0]<0.1 && tabvx[1]<0.1 && tabvx[2]<0.1 && tabvx[3]<0.1 && tabvx[4]<0.1 ) {
            vx=0;
            printf("Vitesse en X mis a zero\n");
            }
        if ( tabay[0]<0.1 && tabay[1]<0.1  && tabay[2]<0.1 && tabay[3]<0.1 && tabay[4]<0.1 && tabvy[0]<0.1 && tabvy[1]<0.1 && tabvy[2]<0.1 && tabvy[3]<0.1 && tabvy[4]<0.1 ) {
            vy=0;
            printf("Vitesse en Y mis a zero\n");
            }
            k++;
    
    // Affichage 
    printf("acceleration en x = %f\n", axx1); 
    printf("acceleration en y = %f\n", ayy1);
    
    printf("vitesse en x = %f mm/s\n", vx);
    printf("vitesse en y = %f mm/s\n", vy);
    
    //printf("acceleration en V = %f\n", V);
    
    } // fin du while

} // fin du main