#include "mbed.h"
#include "DebouncedIn.h"
#include "C12832_lcd.h"

Ticker tick;
C12832_LCD lcd;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DebouncedIn button(p12);

int init();
int ledsOn();
int auswertung();

int(*action[3])()= {init, ledsOn, auswertung };  

volatile int event=0;
float initTime = 0;
bool startreaction;
float reactionTime = 0;

void reactionTick();
void startTime();


void RandomTime()
{
    float min = 0.8 / 6.3;
    float max = 6.2 / 6.3;
 
    initTime = min + ((float)rand()/RAND_MAX) * (max - min) * 6.3;
}

void startTimerStart()
{
    RandomTime();
    tick.attach(&startTime, 0.1);
}

void stopTimer()        
{ 
    tick.detach();
}

void ledsEin()   
{ 
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
}

void ledsAus()   
{ 
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

int init()
{
    startreaction = false;
    ledsAus();    
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Reaktionstester: ");
    return 0;    
}

int ledsOn()
{
    ledsEin();
    lcd.printf("Running: ");
    startTimerStart();
    return 0;    
}

int auswertung()
{
    if(startreaction)
    {
        stopTimer();
        lcd.locate(0, 10);
        lcd.printf("Zeit: %.3f s", reactionTime);
    }
    else
    {
        stopTimer();
        lcd.locate(0, 10);
        lcd.printf("Zu frueh!!!!");
    }
    event = -1;
    return 0;    
}

void reactionTimerStart()
{
    reactionTime = 0;
    tick.attach(&reactionTick, 0.001);
}

void startTime()
{
    initTime -= 0.1;
    
    if(initTime <= 0)
    {
        startreaction = true;
        ledsAus();
        stopTimer();
        reactionTimerStart();
    }
}

void reactionTick()
{
    reactionTime += 0.001;
}

int main()
{    
    (action[event])();
    
    while(1) {  
        if (button.rising()) {
            event++;
            (action[event])();
        }
    }
}

