#include "mbed.h"
#include "DebouncedIn.h"
#include "C12832_lcd.h"

Ticker tick;
C12832_LCD lcd;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DebouncedIn button(p12);

volatile unsigned int event=0;
float initTime = 0;
bool startreaction = false;
float reactionTime = 0;

void reactionTick();
void startTime();

void RandomTime()
{
    float min = 0.8 / 6.3;
    float max = 6.2 / 6.3;
 
    initTime = min + ((float)rand()/RAND_MAX) * (max - min) * 6.3;
}

void startTimerStart()
{
    RandomTime();
    tick.attach(&startTime, 0.1);
}

void reactionTimerStart()
{
    reactionTime = 0;
    tick.attach(&reactionTick, 0.001);
}

void stopTimer()        
{ 
    tick.detach();
}

void ledsEin()   
{ 
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
}

void ledsAus()   
{ 
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

void startTime()
{
    initTime -= 0.1;
    
    if(initTime <= 0)
    {
        startreaction = true;
        ledsAus();
        stopTimer();
        reactionTimerStart();
    }
}

void reactionTick()
{
    reactionTime += 0.001;
}

void doEvent()
{
    switch(event)
    {
     case 0: 
        ledsAus();    
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Reaktionstester: ");
        break; 
     case 1:
        ledsEin();
        lcd.printf("Running: ");
        startTimerStart();
        break;
     case 2: 
        if(startreaction)
        {
            stopTimer();
            lcd.locate(0, 10);
            lcd.printf("Zeit: %.3f s", reactionTime);
        }
        else
        {
            stopTimer();
            lcd.locate(0, 10);
            lcd.printf("Zu frueh!!!!");
        }
        break;  
     case 3: 
        event = 0;
        ledsAus();    
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Reaktionstester: ");
        break;
     default: 
        break;  
    }
}

int main()
{    
    doEvent();
    
    while(1) {  
        if (button.rising()) {
            event++;
            doEvent();
        }
    }
}

