#include "mbed.h"
#include <ctype.h>
#include "FastAnalogIn.h"
#include "arm_math.h"
#define NUM_TAPS 29
#define block_size 32

FastAnalogIn audioin(PTC2); //Analog in
AnalogOut audioout(PTE30); //Analog out
Ticker sampleing; //ticker is a class that automatically interrupts the processor on an interval
DigitalOut l(PTA1);
DigitalOut set1(LED1);
DigitalOut set2(LED2);
DigitalIn state(PTA2);

int fill_index = 0;
int dump_index = 1;
int ready_index =2;
int numblocks;
int buffer_ready = 0;
int samplecounter = 0;
int i,k;

const int num_samples = 512; //512 max! kmc
const int num_buffers = 3;

float32_t buffer[num_buffers][num_samples];
arm_fir_instance_f32 H,L;

static float32_t firStateF32_L[block_size + NUM_TAPS - 1];
static float32_t firStateF32_H[block_size + NUM_TAPS - 1];
float32_t  *inputF32, *outputF32, *processingF32;

const float32_t firCoeffs32_H[NUM_TAPS] = {
    .0000574316875202937f, 0.000259433064931947f, 0.000437449344311845f, -0.000166641902553674f,
    -0.00238511586135069f, -0.00525856044788883f, -0.00452383563647740f, 0.00502173506378964f,
    0.0222334773814194f, 0.0330963994141118f, 0.0145265901181610f, -0.0486381603203359f,
    -0.144905311828843f, -0.234315167629590f, 0.729118629590472f,-0.234315167629590f,-0.144905311828843f,
    -0.0486381603203359f, 0.0145265901181610f, 0.0330963994141118f, 0.0222334773814194f,
    0.00502173506378964f, -0.00452383563647740f, -0.00525856044788883f, -0.00238511586135069f,
    -0.000166641902553674f, 0.000437449344311845f,  0.000259433064931947f, .0000574316875202937
};

const float32_t firCoeffs32_L[NUM_TAPS] = {
    0.000794455095852286f, -0.00145678301449100f, -0.00401267242044256f, -0.00774677450389924f,
    -0.0115271352127628f, -0.0134875234349854f, -0.0112906732230415f, -0.00273103203148382f,
    0.0134991003647579f, 0.0371289350679086f, 0.0659791021599723f, 0.0961528037475044f,
    0.122766312185753f, 0.141063665542080f, 0.147583022099822f, 0.141063665542080f, 0.122766312185753f,
    0.0961528037475044f, 0.0659791021599723f, 0.0371289350679086f, 0.0134991003647579f,
    -0.00273103203148382f, -0.0112906732230415f, -0.0134875234349854f, -0.0115271352127628f,
    -0.00774677450389924f, -0.00401267242044256f, -0.00145678301449100f, 0.000794455095852286
};

void samplingCallback(){
    buffer[fill_index][samplecounter] = audioin;
    audioout = buffer[dump_index][samplecounter];
    if(++samplecounter>=num_samples){
        samplecounter = 0;
        ready_index = fill_index;
        if(++fill_index >= num_buffers){ 
            fill_index = 0;
        }
        if(++dump_index >= num_buffers){ 
            dump_index = 0;
        }
        buffer_ready = 1;
    }
}

void getfilter()
{
    if(state == 1) {
        for(i=0; i<numblocks; i++) {
            arm_fir_f32(&H, inputF32+(i*block_size) , outputF32+(i*block_size), block_size);
        }
        set1 = 1;
        set2 = 0;
    } else {
        for(i=0; i<numblocks; i++) {
            arm_fir_f32(&L, inputF32+(i*block_size) , outputF32+(i*block_size), block_size);
        }
        set1 = 0;
        set2 = 1;
    }
    buffer_ready = 0;
}

void samplingBegin(){
    numblocks = num_samples/block_size;
    samplecounter = 0;
    sampleing.attach_us(&samplingCallback, 125); //sample rate 40k 25, 45k 22, 50k,20
}

int samplingisdone(){
    return buffer_ready;
}

void zerobuffers(){
    for(i=0; i<=num_buffers; i++) {
        for(k=0; k<num_samples; k++) {
            buffer[i][k] = 0.0;
        }
    }
}

int main(){
    arm_fir_init_f32(&H, NUM_TAPS, (float32_t *)&firCoeffs32_H[0], &firStateF32_H[0], block_size);
    arm_fir_init_f32(&L, NUM_TAPS, (float32_t *)&firCoeffs32_L[0], &firStateF32_L[0], block_size);
    ///zerobuffers();
    samplingBegin();
    while(1){
        if(samplingisdone()==1){
            l = 1;
            inputF32 = &buffer[ready_index][0];
            outputF32 = &buffer[dump_index][0];
            getfilter();
            l = 0;
        }
    }
} 