#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"

//UID lookup address and pointer
#define UID_ADDR 0x1FFF7A10
unsigned long *uid = (unsigned long *) UID_ADDR; 

//UID and drive board calibration table
#define UID_TABLE_LENGTH 4

int drive_board_serial_number[UID_TABLE_LENGTH] =
  {1,
   2,
   3,
   4};

unsigned long drive_board_uid[UID_TABLE_LENGTH][3] =
 {{0x005B0060, 0x32375101, 0x32363531},
  {0x00530028, 0x32375116, 0x30333732}, // previous board 2 ID  {0x22222221, 0x22222222, 0x22222223},
  {0x33333331, 0x33333332, 0x33333333},
  {0x44444441, 0x44444442, 0x44444443}};

float drive_board_cal[UID_TABLE_LENGTH][2] = 
 {{0.1, 1.1},
  {0.2, 1.2},
  {0.3, 1.3},
  {0.4, 1.4}}; 

MODSERIAL pc(PA_9, PA_10, 512); //mcu TX, RX, 512 byte TX and RX buffers


int main()
{

    pc.baud(115200);

    pc.printf("on\n");

    pc.printf("\r\nUnique ID: %08X %08X %08X \r\n", uid[0], uid[1], uid[2]);   
    
    int i_board = 0;
    
    for (int i = 0; i < UID_TABLE_LENGTH; i++)
    {
      if (uid[0]==drive_board_uid[i][0] && uid[1]==drive_board_uid[i][1] && uid[2]==drive_board_uid[i][2])
        {
            i_board = drive_board_serial_number[i];
            i = UID_TABLE_LENGTH;
        }
    }
    
    if (i_board > 0) pc.printf("Drive board: BRD%d\n",i_board);
    else pc.printf("Drive board UID match not found\n");
           
}
