#include "mbed.h"

#define CH_A 1     // value of convst bus to read channel A only
#define CH_AC 5     // value of convst bus to read channels A and C
#define CH_ABCD 15 // value of convst bus to read all chanels simultaneously

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut drive(p21);
DigitalOut yLED(p27);
DigitalOut gLED(p28);
DigitalOut rLED(p26);

AnalogIn battVolt(p19);
AnalogIn auxVolt(p20);

BusOut convt(p11, p12, p13, p14);
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);  //chip select
DigitalIn busy(p9);
DigitalOut reset(p10);

char buffer16[16];
int val_array[8];
const char dummy = 0;
int drivetime_ms;

char outString[100];

int readChannels (char buffer[16], int values[8]){
    //simultaneously samples and reads into buffer
    short int val_array[8];
             
    //send convert signal to channels
    convt = CH_AC;
    wait_us(1);
    convt = 0;
                
    //SPI(like) data transfer
    cs = 0;
    spi.write(&dummy, 1, buffer, 16);
    cs=1;
       
    //loop over bytes to add channel voltage values
    for (int i=0; i<8; i++){
        val_array[i] = buffer[2*i]<<8 | buffer16[(2*i) + 1];
        values [i] = val_array[i];   
        }
            
    return 0;
    }
    

int main() {
    int n_samples = 10000;
    double r;
    double r_max = 0;
    double r_min = 1e10;
    double r_sum = 0;
    double r_sum2 = 0;
    double r_mean;
    double r_mean2;
    double r_sd;
    double r_cv;
     
    rLED = 0;
    yLED = 0;
    gLED = 0;
    
    drive = 0;
    drivetime_ms = 1;
       
    pc.baud(115200);
    pc.printf("Test start\r\n");
    
    //Reset ADC sequence
    reset = 1;
    wait_ms(1);
    reset = 0;
    
    //set SPI serial to 2MHz, 16 bit data transfer, mode 2 (clock normally high, data preceeding clock cycle) 
    spi.format(8,2);
    spi.frequency(2000000);
    spi.set_default_write_value(0x00);
    cs = 1;

    rLED = 1;
    yLED = 0;
    gLED = 1;
    
    sprintf(outString, "I1SIG, I1REF, V1POS, V1NEG,        R\r\n");
    pc.printf("%s", outString);
    
    for (int x=0; x<n_samples; x++) {
        drive = 1;
        yLED = 1;
        wait_ms(drivetime_ms);
        readChannels (buffer16, val_array);
        drive = 0;
        yLED = 0;
        
        r = (double)(val_array[5]-val_array[4])/(double)(val_array[1]-val_array[0]);
        if (r < r_min) { r_min = r; }
        if (r > r_max) { r_max = r; }
        r_sum = r_sum + r;
        r_sum2 = r_sum2 + (r*r);

        sprintf(outString, "%5d\t %5d\t %5d\t %5d\t %f\r\n", val_array[0], val_array[1], val_array[4], val_array[5], r);
        pc.printf("%s", outString); 
        wait_ms(1000);
        
        }

    r_mean = r_sum/n_samples;
    r_mean2 = r_sum2/n_samples;
    r_sd = sqrt(r_mean2-(r_mean*r_mean));
    r_cv = r_sd/r_mean;

//    pc.printf("Statistics:\r\n"); 
//    pc.printf("n_samples : %d\r\n", n_samples); 
//    pc.printf("r_mean    : %f\r\n", r_mean); 
//    pc.printf("r_min     : %f\r\n", r_min); 
//    pc.printf("r_max     : %f\r\n", r_max); 
//    pc.printf("r_sd      : %f\r\n", r_sd); 
//    pc.printf("r_cv      : %f\r\n", r_cv);  

    rLED = 0;
    
 }
