#include "mbed.h"
#include "MODSERIAL.h"
#include "Watchdog.h"
#include "ADS8568_ADC.h"
#include "Heater.h"
#include "FastPWM.h"


/*------------------------------------------------------------------------------
Codebase for T99004 Demo Control Board Rev A Firmware
Date: 10/07/2018
Author: AS7


------------------------------------------------------------------------------*/

#define ALL_CH 15               //value of convst bus to read all chanels simultaneosly
#define MEASUREMENT_WAIT    5   //The wait time between reads in seconds

Watchdog wd;                    //instantiate watchdog class

MODSERIAL pc(PA_9, PA_10, 512); //mcu TX, RX, 512 byte TX and RX buffers

//ADC object inherits SPI, 
ADS8568_ADC adc(PB_15, PB_14, PB_13, PB_12, PC_15, PC_0, PC_1, PC_2, PC_3);

//SPI spi(PB_15, PB_14, PB_13);   // mosi, miso, sclk
I2C i2c(PB_7, PB_8);            //SDA, SCL

//indicator LEDs
DigitalOut hb_led(PC_13);       //Green
DigitalOut led_0(PC_4);         //Red
DigitalOut led_1(PC_5);         //Green

//User buttons
DigitalIn user_0(PB_0);
DigitalIn user_1(PB_1);

//ADC
//BusOut adc_convt(PC_0, PC_1, PC_2, PC_3);   //channel convert ch_A, ch_B, ch_C, ch_D
//DigitalOut adc_ncs(PB_12);                   //chip n_select
DigitalIn adc_busy(PA_8);                   //Busy interrupt sig
//DigitalOut adc_reset(PC_15);

/*ADC channels are connected as follows------------
CH_A0 = Heater 1 Current Sense
CH_A1 = Heater 1 Voltage Sense
CH_B0 = Heater 2 Current Sense
CH_B1 = Heater 2 Voltage Sense
CH_C0 = Photodiode Amp Out 1
CH_C1 = Photodiode Amp Out 2
CH_D0 = Photodiode Amp Out 3
CH_D1 = Photodiode Amp Out 4
---------------------------------------------------*/

//Heater Control
FastPWM drive_1(PC_9);
FastPWM drive_2(PC_8);
FastPWM guard_1(PC_7);
FastPWM guard_2(PC_6);
Timer timer;


//Global vars instatiation (to be moved to new places)
char buffer16[16];
float voltages[8];
int values[8];
int i = 0;
int log_count = 0;

float cur1 = 0;
float cur2 = 0;
float R1 = 0;
float R2 = 0;
float scale_factors[8];
float scale_factor = 13.273;
int drivetime_ms = 0;
int OSR = 1;
float R_avg = 0;

char outString[100];

Heater heater_1(0,1,&drive_1, &guard_1, 291, -209);
Heater heater_2(2,3,&drive_2, &guard_2, 286, -203);


int main()
{
    // Initialsation
    
    //for (int i = 0; i<8; i++) {scale_factors[i] = 13.273;} //TODO tweak for each individual channel 
    pc.baud(115200);        
    //led_1 = drive_1; //tie led 1 and heater 1 outputs together so LED shows while heater is on (initial debug purposes only)
    //wd.Configure(30.0);              //configure watchdog timer to 1s interval
    adc.init();                     //initialise ADC
    timer.start();                  //Start the timer   
    drivetime_ms = 50;
    
    //Initialise drive periods
    drive_1.period_us(PWM_PERIOD);      
    drive_2.period_us(PWM_PERIOD);    
    guard_1.period_us(PWM_PERIOD);      
    guard_2.period_us(PWM_PERIOD); 
        
  
    pc.printf("Number of reads, Time (ms), Current 1, Voltage 1, Resistance 1, Current 2, Voltage 2, Resistance 2");
    
    
    while(1){
        
        heater_1.read();
        heater_2.read();
        pc.printf("%d,%d,%d,%d,%f,%d,%d,%f\n",log_count,timer.read_ms(),heater_1.Get_i(),heater_1.Get_v(),heater_1.Get_R(),heater_2.Get_i(),heater_2.Get_v(),heater_2.Get_R());
        wait(MEASUREMENT_WAIT);

    }    
    
        
}
