#include <events/mbed_events.h>
#include <mbed.h>
#include "BLE_EH.h"

static events::EventQueue event_queue(16 * EVENTS_EVENT_SIZE);

RawSerial serial(P0_6, P0_8, 115200);

void schedule_ble_events(BLE::OnEventsToProcessCallbackContext *context) {
    event_queue.call(Callback<void()>(&context->ble, &BLE::processEvents));
}

void buttonPress(int id) {
    serial.printf("Button Pressed: %d\n", id);
}

InterruptIn b1(BUTTON1);
InterruptIn b2(BUTTON2);
InterruptIn b3(BUTTON3);
InterruptIn b4(BUTTON4);

void alive() {
    serial.printf("Blink\n");
}

int main() {
//    serial.getc(); //DEBUG ONLY - pauses until first keypress
    serial.set_flow_control(SerialBase::RTSCTS, P0_5, P0_7);
    
    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(schedule_ble_events);
    BLE_EH ble_eh(ble, event_queue);
    ble_eh.start();
    serial.printf("BLE started\n");
    
    b1.rise(event_queue.event(&buttonPress, 1));
    b2.rise(event_queue.event(&buttonPress, 2));
    b3.rise(event_queue.event(&buttonPress, 3));
    b4.rise(event_queue.event(&buttonPress, 4));

    event_queue.call_every(2000, &alive);
    event_queue.dispatch_forever();
    return 0;
}
