#ifndef __BLE_EH_H__
#define __BLE_EH_H__

#include <mbed.h>
#include <events/mbed_events.h>
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"

class BLE_EH : public ble::Gap::EventHandler {
public:
    BLE_EH(BLE &ble, events::EventQueue &event_queue);

    void start();
    
    void setBatteryLevel(uint8_t level);

private:
    /** Callback triggered when the ble initialization process has finished */
    void on_init_complete(BLE::InitializationCompleteCallbackContext *params);

    void start_advertising();

private:
    /* Event handler */

    virtual void onDisconnectionComplete(const ble::DisconnectionCompleteEvent&);

    BLE &_ble;

    UUID _battery_uuid;
    BatteryService _battery_service;
    
    DeviceInformationService _device_information_service;

};

#endif//__BLE_EH_H__