#include "BLE_EH.h"

BLE_EH::BLE_EH(BLE &ble, events::EventQueue &event_queue) :
    _ble(ble),
    _battery_uuid(GattService::UUID_BATTERY_SERVICE),
    _battery_service(ble, 50),
    _device_information_service(ble, "MANUFACTURER", "MODEL", "SERIAL", "HARDWARE", "FIRMWARE", "SOFTWARE")
{
}

void BLE_EH::start() {
    _ble.gap().setEventHandler(this);

    _ble.init(this, &BLE_EH::on_init_complete);
}

/** Callback triggered when the ble initialization process has finished */
void BLE_EH::on_init_complete(BLE::InitializationCompleteCallbackContext *params) {
    if (params->error != BLE_ERROR_NONE) {
        //print_error(params->error, "Ble initialization failed.");
        return;
    }
    start_advertising();
}

void BLE_EH::start_advertising() {
    /* Create advertising parameters and payload */
    uint8_t _adv_buffer[ble::LEGACY_ADVERTISING_MAX_SIZE];
    ble::AdvertisingDataBuilder _adv_data_builder(_adv_buffer);

    ble::AdvertisingParameters adv_parameters(
        ble::advertising_type_t::CONNECTABLE_UNDIRECTED,
        ble::adv_interval_t(ble::millisecond_t(1000))
    );

    _adv_data_builder.setFlags();
    _adv_data_builder.setLocalServiceList(mbed::make_Span(&_battery_uuid, 1));
    _adv_data_builder.setName("DEVICE_NAME");

    /* Setup advertising */

    ble_error_t error = _ble.gap().setAdvertisingParameters(
        ble::LEGACY_ADVERTISING_HANDLE,
        adv_parameters
    );

    if (error) {
        //print_error(error, "_ble.gap().setAdvertisingParameters() failed");
        return;
    }

    error = _ble.gap().setAdvertisingPayload(ble::LEGACY_ADVERTISING_HANDLE, _adv_data_builder.getAdvertisingData());

    if (error) {
        //print_error(error, "_ble.gap().setAdvertisingPayload() failed");
        return;
    }

    /* Start advertising */

    error = _ble.gap().startAdvertising(ble::LEGACY_ADVERTISING_HANDLE);

    if (error) {
        //print_error(error, "_ble.gap().startAdvertising() failed");
        return;
    }
}

void BLE_EH::setBatteryLevel(uint8_t level) {
    _battery_service.updateBatteryLevel(level);
}

/* Event handler */

void BLE_EH::onDisconnectionComplete(const ble::DisconnectionCompleteEvent&) {
    _ble.gap().startAdvertising(ble::LEGACY_ADVERTISING_HANDLE);
}