#include "mbed.h"
#include "BikeData.h"
#include "BatteryState.h"
#include "BikeControl.h"
#include "ble/BLE.h"
#include "ble/services/BikeService.h"
#include "ble/services/BikeBatteryService.h"

#define trailerBatteryPin  PB_0
#define bikeBatteryPin  PC_5
#define auxiliaryBatteryPin  PC_4

/***************************************************************************
                                VARIABLES
****************************************************************************/

/*
//LIGHT
DigitalOut lightFront(PB_14);
DigitalOut lightBack(PA_11);
DigitalOut lightLeft(PC_6);
DigitalOut lightRight(PC_8);*/


static BikeControl *bc;


//3 battery states
static BatteryState *trailerBattery;
static BatteryState *bikeBattery;
static BatteryState *auxiliaryBattery;

//BLE VARIABLES
static char     DEVICE_NAME[] = "NAME";  //Define default name of the BLE device
static const uint16_t uuid16_list[] = {BikeService::BIKE_SERVICE_UUID, 
                                        //GattService::UUID_DEVICE_INFORMATION_SERVICE,
                                        BatteryService::BATTERY_SERVICE_UUID,
                                        }; // List of the Service UUID's that are used.

//Pointers to diferent objects and BLE services.
static BikeData *bd;
static BikeService *bikeServicePtr;
//static DeviceInformationService *DISptr;
static BatteryService *batSerPtr;

//bool that is set to true each second.
static bool update = false;
static bool updateHalf = false;

/***************************************************************************
                                CONTROL FUNCTIONS
****************************************************************************/
/*void runTestLight()
{
    printf("front\n");
    lightFront =1;
    wait(1);
    lightFront = 0;
    printf("back\n");
    lightBack = 1;
    wait(1);
    lightBack = 0;
    printf("left\n");
    lightLeft = 1;
    wait(1);
    lightLeft = 0;
    printf("right\n");
    lightRight = 1;
    wait(1);
    lightRight = 0;
    wait(1);
}*/

/***************************************************************************
                                BLE FUNCTIONS
****************************************************************************/

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    //restart advertising when disconnected
    BLE::Instance().gap().startAdvertising();
}
 
void periodicCallback(void)
{
    //Set update high to send new data over BLE
    update = true;
}
 

 //This function is called when the ble initialization process has failled
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Initialization error handling should go here */
    printf("initialization error!\n");
}
 

//Callback triggered when the ble initialization process has finished
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;
 
    if (error != BLE_ERROR_NONE) {      /* In case of error, forward the error handling to onBleInitError */
        printf("BLE error\n");
        onBleInitError(ble, error);
        return;
    }
 
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    //set the disconnect function
    ble.gap().onDisconnection(disconnectionCallback);
    printf("BLE Disconnect callback set\n");
 
    /* Setup primary services */
    //DISptr = new DeviceInformationService(ble, "The Opportunity Factory", "1.0", "PJTMN06", "1.0", "0.9", "0.9");
    bikeServicePtr = new BikeService(ble,bd);
    batSerPtr = new BatteryService(ble,
                                    trailerBattery->getBatteryPercentage(),
                                    bikeBattery->getBatteryPercentage(),
                                    auxiliaryBattery->getBatteryPercentage());
    
    printf("Services set\n");
 
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_CYCLING);//set apperance
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); //different BLE options set
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));//Adding the list of UUID's
    //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));//passing the device name
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, bd->getBikeNameSize());//passing the device name
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);//setting connection type
    ble.gap().setAdvertisingInterval(100); /* 1000ms. */
    ble.gap().startAdvertising();
    printf("advertising\n");
}


int main() {
    
    
    printf("\n======================\n\n");
    printf("SETUP \n");
    
    bd = new BikeData(PC_1); // creating BikeData object
    printf("BikeData object created\n");
    
    
    trailerBattery = new BatteryState(trailerBatteryPin,BatteryState::Battery48V);
    bikeBattery = new BatteryState(bikeBatteryPin,BatteryState::Battery48V);
    auxiliaryBattery = new BatteryState(auxiliaryBatteryPin,BatteryState::Battery48V);
    
    bc = new BikeControl(bd,trailerBattery, bikeBattery, auxiliaryBattery);
    
    
    printf("run TestLight \n");
    //runTestLight();
    bc->runTestLight();
    
    uint8_t size = bd->getBikeNameSize();
    printf("name length: %i\n", size);
    if (size == 0){
        printf("Setting Name First Time\n");
        static char     testName[] = "Tortuga";
        bd -> setBikeName((char *)testName,sizeof(testName));
        printf("SetFistTimeName\n");
        //printf( "size: %i\n",bd -> getBikeNameSize());
        //printf("first character: %c",bd->getBikeName());
    }
    
    bd->getBikeName(DEVICE_NAME);
    printf("got device name\n");
    BLE &ble = BLE::Instance(); // creating BLE object
    printf("BLE object created\n");
    BLE::Instance().init(bleInitComplete); // call init function
    
    while (ble.hasInitialized()  == false); // Wait until BLE is initialized
    printf("BLE object intitialized\n");
    Ticker ticker;
    ticker.attach(periodicCallback, 1); //creating the ticker that wil update each second.
    printf("ticker 1 attached\n");
    
    printf("START \n");
    
    
    bc->startControlLoop();
    
    while(true)
     {
         if (update){
            printf("--------------\n");
            float distance = (bd->getDataSet(BikeData::OVERALL))->getDistance();
            printf("main distance: %f\n", distance);
            float speed = bd->getSpeed();
            printf("main speed: %f\n", speed);
            
            //printf("update bikeService\n");
            bikeServicePtr->update(); //update the bikeserice
            //printf("update battery1: %i\n", trailerBattery->getBatteryPercentage());
            //batSerPtr->updateBatteryLevel1((++batLevel)%=101);
            //printf("battery level: %i\n", batLevel);
            batSerPtr->updateBatteryLevel1(trailerBattery->getBatteryPercentage());
            //printf("update battery2: %i\n", bikeBattery->getBatteryPercentage());
            batSerPtr->updateBatteryLevel2(bikeBattery->getBatteryPercentage());
            //printf("update battery3: %i\n", auxiliaryBattery->getBatteryPercentage());
            batSerPtr->updateBatteryLevel3(auxiliaryBattery->getBatteryPercentage());
            update = false;
        }
        ble.waitForEvent(); //wait for an event when idle.
        
        bc->checkStatus();            
    }
}   
