#include "mbed.h"
#include "Data.h"


//CONSTRUCTOR
Data::Data(float startDistance, uint32_t startTime, uint8_t ppr, float Periphery) :
    //setting start values up
    StartTime(time(NULL)-startTime),
    distance(startDistance),
    PPR(ppr),
    periphery(Periphery)
    {
        
    }
    
void Data::interval(int count){
    //log each interval and update the status
    distance += count * periphery / PPR;
    //debugging
    //printf("distance: %f \r\nTime Passed: %i:%i:%i\nAverage: %f\n\n",distance,(time(NULL) - StartTime)/3600, ((time(NULL) - StartTime)/60)%60, (time(NULL) - StartTime)%60, (distance/(time(NULL) - StartTime) * 3.6));
    }
    
float Data::getDistance(void){
    return distance;
    }

uint32_t Data::getTime(void){
    return (time(NULL) - StartTime);
    }
    
float Data::getAverage(void){
    return distance/(time(NULL) - StartTime) * 3.6;
    }
    
