#ifndef BIKEDATA_H
#define BIKEDATA_H
#include "mbed.h"
#include "Data.h"

class BikeData{
protected:
    InterruptIn button;
    Ticker tick;
    Data *overallData;
    Data *tripData;
    Data *batChangeData;
    Data* dataSet[3];
    bool logging;
    uint8_t count;
    float lastDistance;
    uint8_t lastCount;
public:
    BikeData(PinName pin);
    int8_t getBikeNameSize();
    void getBikeName(char *name);
    void setBikeName(char* name,uint8_t length);
    void pressed(void);
    void interval(void);
    Data* getDataSet(uint8_t type);
    void startTrip();
    void pauzeTrip();
    void stopTrip();
    float getSpeed(void);
    float getRPM();
    uint8_t getLastCount(void);
    bool isLogging();
    
    enum{
        OVERALL = 0,
        TRIP = 1,
        BATCHANGE = 2
    };
};
    
#endif