#include "mbed.h"
#include "BikeData.h"
#include "Data.h"
#include "_24LCXXX.h"

#define Period 1        //1000ms period of sampling
#define PPR 51          // Pulses Per Rotation
#define periphery 1.595928736  //periphery of the wheel in meters

#define EEPROM_ADDR 0x0   // I2c EEPROM address is 0x00
#define SDA PB_9            // I2C SDA pin
#define SCL PB_8           // I2C SCL pin


I2C i2c(PB_9, PB_8);
Serial pc(SERIAL_TX, SERIAL_RX);
_24LCXXX mem(&i2c);

/*
EEPROM ADRESSES:

0->3: overall distance
4->7: overall time
8: name size
9->...: bike name
*/

//CONSTRUCTOR
BikeData::BikeData(PinName pin) : 
    button(pin),
    logging(false),
    count(0),
    lastDistance(0)
    {
       
        //setting things up for logging the raw data.
        float readDistance;
        printf("reading...\n");
        if(mem.nbyte_read(0,&readDistance,sizeof(float))){
            printf("eeprom reading error");
            }
        printf("data read: %f\n",readDistance);
        uint32_t readTime;
        if(mem.nbyte_read(4,&readTime,sizeof(uint32_t))){
            printf("eeprom reading error");
            }
        printf("data read: %#x\n",readTime);
        
        overallData = new Data(readDistance,readTime,PPR,periphery);
        dataSet[OVERALL] = overallData;
        batChangeData = new Data(0.0,0,PPR,periphery);
        dataSet[BATCHANGE] = batChangeData;
        
        tick.attach(this,&BikeData::interval,Period);
        button.fall(this,&BikeData::pressed);
    }
    
int8_t BikeData::getBikeNameSize(){
    //printf("size retrieving\n");
    int8_t size = 0;
    //mem.read(8,size);
    if(mem.nbyte_read(8,&size,sizeof(int8_t))){
            printf("eeprom reading error");
            }
    //printf("size retrieved: %i\n", size);
    return size;
    }
    
void BikeData::getBikeName(char *name){
    printf("name retrieving\n");
    uint8_t size = getBikeNameSize();
    //uint8_t* name;
    //mem.read(9,name, size);
    if(mem.nbyte_read(9,name,size)){
            printf("eeprom reading error");
            }
    //printf("name retrieved\n");
    //return name;
    }
    
void BikeData::setBikeName(char *name, uint8_t length){
    printf("setting bike name size to eeprom\n");
    //mem.write(8,(int8_t)length);
    printf("length: %i\n", length);
    if(mem.nbyte_write(8,&length,1)){
            printf("eeprom writing error");
            }
    //printf("setting bike name to eeprom\n");
    //mem.write(9,name, length);
    if(mem.nbyte_write(9,name,length)){
            printf("eeprom writing error");
            }
    //printf("name set\n");
    
    }
    
void BikeData::startTrip(){
    //start trip function, creating new tripdata object
    tripData = new Data(0.0,0,PPR,periphery);
    dataSet[TRIP] = tripData; // setting the pointer position to the tripdata object
    logging = true; // start logging
    }
    
void BikeData::pauzeTrip(){
    logging = !logging;
    }

void BikeData::stopTrip(){
    logging = false;
    }
    
void BikeData::pressed(void){
        //count each pulse of the sensor
        count++;
    }
    
Data* BikeData::getDataSet(uint8_t type){
        return dataSet[type];
    }
    
float BikeData::getSpeed(void){
    return lastDistance/Period * 3.6;
    }
    
float BikeData::getRPM(){
    return lastCount/PPR*60;
    }
    
uint8_t BikeData::getLastCount(void){
    return lastCount;
   } 
   
bool BikeData::isLogging(void){
    return logging;
   } 
    
//interval function is called each second to monitor the progress by the datasets
void BikeData::interval(void){
        //calculate the distances
        lastDistance = count * periphery / PPR;
        lastCount = count;
        
        //printf("\n==================\n\n"); // debugging
        if(logging){ // only interval when needed
             //printf("Trip:\n------------------\n");
             tripData->interval(count); // send interval to the tripdata object
         }
        //printf("Overall:\n------------------\n");
        overallData->interval(count);
        
        // update the eeprom values
        float overallDistance = overallData->getDistance();
        if(mem.nbyte_write(0,&overallDistance,4)){
            printf("eeprom writing error distance\n");
            }
        uint32_t overallTime = overallData->getTime();
        if(mem.nbyte_write(4,&overallTime,4)){
            printf("eeprom writing error time\n");
            }
        
        //printf("batChange:\n------------------\n");
        batChangeData->interval(count);
        //printf("speed: %f\ncount: %i\n",lastDistance/Period * 3.6, lastCount); // debugging
        count = 0;
    }
    
