#include "mbed.h"
#include "BatteryState.h"
#define batVoltage_Factor_48V 0.001510643 //Voltage increase when readValue increases with 1.
                                           // calculated for max 60V 



BatteryState::BatteryState(PinName pin, batteryType batType):
    batteryPin(pin),
    type(batType){
        }

uint8_t BatteryState::getBatteryPercentage(){
    uint16_t readValue = /*34500;*/batteryPin.read_u16();//reading the adc value
    
    if (type == Battery48V){
    double BatVoltage = (readValue * batVoltage_Factor_48V); // convert it to battery voltage
    
    if(BatVoltage > 54) return 100;
    else if (BatVoltage > 53.22) return 95;
    else if (BatVoltage > 52.86) return 90;
    else if (BatVoltage > 52.69) return 80;
    else if (BatVoltage > 52.53) return 70;
    else if (BatVoltage > 52.35) return 60;
    else if (BatVoltage > 52.18) return 50;
    else if (BatVoltage > 51.82) return 40;
    else if (BatVoltage > 51.47) return 30;
    else if (BatVoltage > 51.14) return 20;
    else if (BatVoltage > 50.61) return 10;
    else  return 0;
    }
    else if (type == Battery12V){
        return 37; //TODO
    }
    return 0;
}
    