#ifndef BIKECONTROL_H
#define BIKECONTROL_H
#include "mbed.h"
#include "BikeData.h"
#include "BatteryState.h"

class BikeControl{
    
protected:
    //State machine states definition
    typedef enum DriveState {
        DRIVE_START=0,
        DRIVE_BRAKE,
        DRIVE_BOOST,
        DRIVE_RUN,
    } DriveState_t;
    
    
    //WHEEL
    //const float WHEEL_CIRCUMFERENCE = 1.66; //Wheel Circumference
    //MOTOR
    //const float GEAR_RATIO = 13.3;     //Motor gear ration
   
    
    //TRAILER
    DigitalOut trailerCtrl;
    
    //MOTOR
    PwmOut motorRightCtrl;
    InterruptIn motorRightHall;
    uint16_t motorRightCounter;
    uint16_t motorRightRpm;
    PwmOut motorLeftCtrl;
    InterruptIn motorLeftHall;
    uint16_t motorLeftCounter;
    uint16_t motorLeftRpm;
    
    //BRAKE
    DigitalIn brakeFront;
    DigitalIn brakeRear;
    
    //GENERATOR
    InterruptIn generatorHallA;
    PwmOut generatorBrake;
    uint16_t generatorHallACounter;
    uint16_t generatorHallARpm;
    InterruptIn generatorHallB;
    uint16_t generatorHallBCounter;
    uint16_t generatorHallBRpm;
    
    //BUTTONS ON STEERING
    //DigitalIn userButton;
    DigitalIn buttonGreen;
    DigitalIn buttonRed;
    DigitalIn buttonDirectionRight;
    DigitalIn buttonDirectionLeft;
    
    //SWITCH
    DigitalIn switchOn;
    DigitalIn switchWalk;
    
    //LIGHT
    DigitalOut lightFront;
    DigitalOut lightBack;
    DigitalOut lightLeft;
    DigitalOut lightRight;
    
    
    void generatorHallAPulsed();
    void generatorHallBPulsed();
    void motorRightPulsed();
    void motorLeftPulsed();
    void periodicCallback();
    
    Ticker t;
    BikeData *bd;
    BatteryState *bikeBat, *trailerBat, *auxBat;
    
public:
    BikeControl(BikeData* bikeData, BatteryState* trailerBat, BatteryState* bikeBat, BatteryState* auxBat);
    void runTestLight();
    void startControlLoop();
    void checkStatus();
};
    
#endif