#include "mbed.h"
#include "BikeControl.h"
#include "BikeData.h"
#include "BatteryState.h"

BikeControl::BikeControl(BikeData* bikeData, BatteryState* trailerBat, BatteryState* bikeBat, BatteryState* auxBat):
    trailerCtrl(PB_1),
    motorRightCtrl(PB_15),
    motorRightCounter(0),
    motorRightRpm(0),
    motorLeftCtrl(PB_13),
    motorLeftCounter(0),
    motorLeftRpm(0),
    motorRightHall(PC_13),
    motorLeftHall(PC_1),
    
    //BRAKE
    brakeFront(PC_10),
    brakeRear(PC_12),
    
    //GENERATOR
    generatorHallA(PD_2),
    generatorBrake(PC_9),
    generatorHallACounter(0),
    generatorHallARpm(0),
    generatorHallB(PC_3),
    generatorHallBCounter(0),
    generatorHallBRpm(0),
    
    //BUTTONS ON STEERING
    //userButton(USER_BUTTON),
    buttonGreen(PB_11),
    buttonRed(PB_12),
    buttonDirectionRight(PA_15),
    buttonDirectionLeft(PB_7),
    
    //SWITCH
    switchOn(PC_11),
    switchWalk(PB_2),
    
    //LIGHT
    lightFront(PB_14),
    lightBack(PA_11),
    lightLeft(PC_6),
    lightRight(PC_8),
    
    bd(bikeData),
    bikeBat(bikeBat),
    trailerBat(trailerBat),
    auxBat(auxBat)
{
        //PullUp on userButton input
        //userButton.mode(PullUp);
        //PullUp on brake inputs
        brakeFront.mode(PullUp);
        brakeRear.mode(PullUp);
    
        //Call function on rise of interruptpin
        generatorHallA.rise(this, &BikeControl::generatorHallAPulsed);
        generatorHallB.rise(this, &BikeControl::generatorHallBPulsed);
        generatorBrake.period_us(50);
        generatorBrake.write(0.5f);
        generatorHallACounter=0;
        generatorHallARpm=0;
        generatorHallBCounter=0;
        generatorHallBRpm=0;
    
        //motor
        motorRightCtrl.period_ms(100);
        motorRightCtrl.write(0.0f);
        motorRightHall.rise(this, &BikeControl::motorRightPulsed);
        motorLeftCtrl.period_ms(100);
        motorLeftCtrl.write(0.0f);
        motorLeftHall.rise(this, &BikeControl::motorLeftPulsed);
    
        //Button inputs
        buttonGreen.mode(PullUp);
        buttonRed.mode(PullUp);
        buttonDirectionRight.mode(PullUp);
        buttonDirectionLeft.mode(PullUp);
    
        //SWITCH
        switchOn.mode(PullUp);
        switchWalk.mode(PullUp);
        
        //t.attach(this, &BikeControl::periodicCallback, 0.5);
    }
    
void BikeControl::startControlLoop(){
    t.attach(this, &BikeControl::periodicCallback, 0.5);
    }
    
void BikeControl::periodicCallback(){
        //printf("callback\n");
        generatorHallARpm = generatorHallACounter*2; //60 rising edges/ rotation means Rpm is equal to the counter value in 1 sec
        generatorHallACounter = 0;
        generatorHallBRpm = generatorHallBCounter*2; //60 rising edges/ rotation means Rpm is equal to the counter value in 1 sec
        generatorHallBCounter = 0;
        motorRightRpm = motorRightCounter*2;
        motorRightCounter = 0;
        motorLeftRpm = motorLeftCounter*2;
        motorLeftCounter = 0;
        if (generatorHallARpm>0) {
            printf("RPM generator Hall A = %i\n",generatorHallARpm);
        }
        if (generatorHallBRpm>0) {
            printf("RPM generator Hall B = %i\n",generatorHallBRpm);
        }
        if (motorRightRpm>0) {
            printf("RPM motor Right = %i\n",motorRightRpm);
        }
        if (motorLeftRpm>0) {
            printf("RPM motor Left = %i\n",motorLeftRpm);
        }
        //printf("light control\n");
        //Turning LIGHT to RIGHT
        if (!buttonDirectionRight) {
            lightRight=!lightRight;
        } else {
            lightRight=0;
        }
        //Turning LIGHT to Left
        if (!buttonDirectionLeft) {
            lightLeft=!lightLeft;
        } else {
            lightLeft=0;
        }
        // Check if the Lights need to be on
        if(!buttonRed) {
            lightFront=1;
            if (trailerBat->getBatteryPercentage()<30) {lightBack=!lightBack;}
            else {lightBack=1;}
        } else {
            lightFront=0;
            if (trailerBat->getBatteryPercentage()<30) {lightBack=!lightBack;}
            else {lightBack=0;}
        }
    }
    
void BikeControl::generatorHallAPulsed()
{
    generatorHallACounter++;
}

void BikeControl::generatorHallBPulsed()
{
    generatorHallBCounter++;
}

void BikeControl::motorRightPulsed()
{
    motorRightCounter++;
}

void BikeControl::motorLeftPulsed()
{
    motorLeftCounter++;
}
    
void BikeControl::runTestLight()
{
    printf("front\n");
    lightFront =1;
    //wait(1);
    for(uint32_t i = 0; i<0xFFFFFF; i++); //WAIT STATEMENT CAUSES FREEZING!!!!! USE FOR LOOP IN STEAD, device can not handle wait and interrupts at same time!
    lightFront = 0;
    printf("back\n");
    lightBack = 1;
    //wait(1);
    for(uint32_t i = 0; i<0xFFFFFF; i++);
    lightBack = 0;
    printf("left\n");
    lightLeft = 1;
    //wait(1);
    for(uint32_t i = 0; i<0xFFFFFF; i++);
    lightLeft = 0;
    printf("right\n");
    lightRight = 1;
    //wait(1);
    for(uint32_t i = 0; i<0xFFFFFF; i++);
    lightRight = 0;
    //wait(1);
}

void BikeControl::checkStatus(){
        
        //STATE MACHINE
        if (!brakeFront || !brakeRear) {
            if(!brakeFront) {
                printf("BRAKE front \n");
            }
            if(!brakeRear) {
                printf("BRAKE rear \n");
            }
            motorRightCtrl.write(0.0f);
            motorLeftCtrl.write(0.0f);
            trailerCtrl=0;
        } else if (!buttonGreen) {
            if (motorRightRpm<=61) {// motorRightRpm=61 means 6km/h
                motorRightCtrl.write(1.0f);
                motorLeftCtrl.write(1.0f);
                trailerCtrl=1;
            } else {
                if (generatorHallARpm<10) {
                    motorRightCtrl.write(0.0f);
                    motorLeftCtrl.write(0.0f);
                    trailerCtrl=0;
                } else if(generatorHallARpm<=100) {
                    motorRightCtrl.write(generatorHallARpm*0.004f);
                    motorLeftCtrl.write(generatorHallARpm*0.004f);
                    if (motorRightRpm<190) { //boven de 18km/h enkel de trekker aansturen
                        trailerCtrl=1;
                    } else {
                        trailerCtrl=0;
                    }
                } else if (generatorHallARpm>100) {
                    motorRightCtrl.write(0.4f);
                    motorLeftCtrl.write(0.4f);
                    if (motorRightRpm<190) { //boven de 18km/h enkel de trekker aansturen
                        trailerCtrl=1;
                    } else {
                        trailerCtrl=0;
                    }
                }
            }
        } else if (generatorHallARpm>=0) {
            if (generatorHallARpm<10) {
                motorRightCtrl.write(0.0f);
                motorLeftCtrl.write(0.0f);
                trailerCtrl=0;
            } else if(generatorHallARpm<=100) {
                motorRightCtrl.write(generatorHallARpm*0.004f);
                motorLeftCtrl.write(generatorHallARpm*0.004f);
                if (motorRightRpm<190) {
                    trailerCtrl=1;
                } else {
                    trailerCtrl=0;
                }
            } else if (generatorHallARpm>100) {
                motorRightCtrl.write(0.4f);
                motorLeftCtrl.write(0.4f);
                if (motorRightRpm<190) {
                    trailerCtrl=1;
                } else {
                    trailerCtrl=0;
                }
            }
        }
    
    }