#ifndef __BLE_BIKE_SERVICE_H__
#define __BLE_BIKE_SERVICE_H__

#include "BikeData.h"
#include "ble/BLE.h"
class BikeService {
public:
/*
    UUID LIST:
    0x6969: SERVICE
        0x696A: Trip Distance
        0x696B: Trip Average
        0x696C: Trip Time (in seconds)
        
        0x696D: Overall Distance
        0x696E: Overall Average
        0x696F: Overall Time (in seconds)
        
        0x6970: Since Battery Change Distance
        0x6971: Since Battery Change Average
        0x6972: Since Battery Change Time (in seconds)
        
        0x6973: pulses in last second
        0x6974: Speed
        0x6975: Control
        0x6976: Device Name
    */


    /*defining the UUID's for the service and characters*/
    const static uint16_t BIKE_SERVICE_UUID              = 0x6969;
    
    const static uint16_t TRIP_DISTANCE_CHARACTERISTIC_UUID = 0x696A;
    const static uint16_t TRIP_AVERAGE_CHARACTERISTIC_UUID = 0x696B;
    const static uint16_t TRIP_TIME_CHARACTERISTIC_UUID = 0x696C;
    
    const static uint16_t OVERALL_DISTANCE_CHARACTERISTIC_UUID = 0x696D;
    const static uint16_t OVERALL_AVERAGE_CHARACTERISTIC_UUID = 0x696E;
    const static uint16_t OVERALL_TIME_CHARACTERISTIC_UUID = 0x696F;
    
    const static uint16_t BATCHANGE_DISTANCE_CHARACTERISTIC_UUID = 0x6970;
    const static uint16_t BATCHANGE_AVERAGE_CHARACTERISTIC_UUID = 0x6971;
    const static uint16_t BATCHANGE_TIME_CHARACTERISTIC_UUID = 0x6972;
    
    const static uint16_t PULSE_CHARACTERISTIC_UUID = 0x6973;
    const static uint16_t SPEED_CHARACTERISTIC_UUID = 0x6974;
    const static uint16_t CONTROL_CHARACTERISTIC_UUID = 0x6975;
    const static uint16_t DEVICE_NAME_CHARACTERISTIC_UUID = 0x6976;
    
    //CONSTRUCTOR
    BikeService(BLE &_ble, BikeData *bikeData) :
                /*define standard/initial value*/
                ble(_ble), 
                bd(bikeData),
                tripDistanceChar(TRIP_DISTANCE_CHARACTERISTIC_UUID,&tripDistance, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                tripAverageChar(TRIP_AVERAGE_CHARACTERISTIC_UUID,&tripAverage, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                tripTimeChar(TRIP_TIME_CHARACTERISTIC_UUID,&tripTime, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                
                overallDistanceChar(OVERALL_DISTANCE_CHARACTERISTIC_UUID,&overallDistance, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                overallAverageChar(OVERALL_AVERAGE_CHARACTERISTIC_UUID,&overallAverage, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                overallTimeChar(OVERALL_TIME_CHARACTERISTIC_UUID,&overallTime, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                
                batChangeDistanceChar(BATCHANGE_DISTANCE_CHARACTERISTIC_UUID,&batChangeDistance, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                batChangeAverageChar(BATCHANGE_AVERAGE_CHARACTERISTIC_UUID,&batChangeAverage, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                batChangeTimeChar(BATCHANGE_TIME_CHARACTERISTIC_UUID,&batChangeTime, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        
                pulseChar(PULSE_CHARACTERISTIC_UUID,&pulse, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                speedChar(SPEED_CHARACTERISTIC_UUID,&speed, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                controlChar(CONTROL_CHARACTERISTIC_UUID,&control, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
                /*deviceNameChar(DEVICE_NAME_CHARACTERISTIC_UUID,
                                              (uint8_t *)bd->getBikeName(),
                                              bd->getBikeNameSize(), 
                                              bd->getBikeNameSize(), 
                                              GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE)*/
    {
        static char devName[] = "tmp";
        bd->getBikeName(devName);
        deviceNameChar = new GattCharacteristic(DEVICE_NAME_CHARACTERISTIC_UUID,
                                              (uint8_t *)devName,
                                              bd->getBikeNameSize(), 
                                              bd->getBikeNameSize(), 
                                              GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);
        /*static char devName[] = "tmp";
        bd->getBikeName(devName);
        ble.gattServer().write(deviceNameChar.getValueHandle(),(uint8_t *)devName,bd->getBikeNameSize());*/
        //read al the values out of the BikeData object
        tripDistance = (bd->getDataSet(BikeData::TRIP))->getDistance() *100;
        tripAverage = (bd->getDataSet(BikeData::TRIP))->getAverage() *100;
        tripTime = (bd->getDataSet(BikeData::TRIP))->getTime();
        
        overallDistance = (bd->getDataSet(BikeData::OVERALL))->getDistance()*100;
        overallAverage = (bd->getDataSet(BikeData::OVERALL))->getAverage()*100;
        overallTime = (bd->getDataSet(BikeData::OVERALL))->getTime();
        
        batChangeDistance = (bd->getDataSet(BikeData::BATCHANGE))->getDistance() *100;
        batChangeAverage = (bd->getDataSet(BikeData::BATCHANGE))->getAverage() *100;
        batChangeTime = (bd->getDataSet(BikeData::BATCHANGE))->getTime();
        
        pulse = bd->getLastCount();
        speed = bd->getSpeed()*100;
        control = bd->isLogging()*5;
        
        //creating a pointer list of al the characteristics
        GattCharacteristic *charTable[] = {&tripDistanceChar, &tripAverageChar, &tripTimeChar,
                                           &overallDistanceChar, &overallAverageChar, &overallTimeChar,
                                           &batChangeDistanceChar, &batChangeAverageChar, &batChangeTimeChar,
                                           &pulseChar, &speedChar, &controlChar, deviceNameChar};
        //creating the gattService
        GattService         bikeService(BikeService::BIKE_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(bikeService);
        //define the function to call when data is written to service
        ble.onDataWritten(this, &BikeService::onDataWrittenCallback);
    }
    
    void onDataWrittenCallback(const GattWriteCallbackParams *writeParams) {
        //when data is written in the controlCharacteristic
        if (writeParams->handle == controlChar.getValueHandle()) {
                //performing different actions according to the written value
                if (*(writeParams->data) == '1'){
                    bd->startTrip();
                }
                else if (*(writeParams->data) == '2'){
                    bd->pauzeTrip();
                }
                else if (*(writeParams->data) == '3'){
                    bd->stopTrip();
                }
            }
            
            if (writeParams->handle == deviceNameChar->getValueHandle()) {
                printf("name changing, length: %i\n",(uint8_t)writeParams->len);
                //uint8_t *recievedName = writeParams->data;
                //writeParams->data->push_back(0x00);
                uint8_t recievedName[writeParams->len +1];
                for (uint8_t i = 0 ; i < writeParams->len ; i++){
                    recievedName[i] = *(writeParams->data+i);
                    }
                recievedName[writeParams->len] = 0x00;
                bd->setBikeName((char *)recievedName,((uint8_t)writeParams->len)+1);
                ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)recievedName, (writeParams->len)+1);//passing the device name
    
                printf("written length: %i\n", bd->getBikeNameSize());
                static char devName[] = "tmp";
                bd->getBikeName(devName);
                ble.gattServer().write(deviceNameChar->getValueHandle(),(uint8_t *)devName,bd->getBikeNameSize());
                /*char name[] = "otherName";
                bd->setBikeName(name,sizeof(name));*/
            }
    }
    
 
    void update(){
        /*updating the different characteristics when the value has changed*/
        uint32_t tmp;
        //TripData
        tmp = ((bd->getDataSet(BikeData::TRIP))->getDistance()) * 100;
        if (tmp != tripDistance){
            tripDistance = tmp;
            ble.gattServer().write(tripDistanceChar.getValueHandle(),(uint8_t *)&tripDistance,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
        }    
        tmp = ((bd->getDataSet(BikeData::TRIP))->getAverage()) * 100;
        if (tmp != tripAverage){
            tripAverage = tmp;
            ble.gattServer().write(tripAverageChar.getValueHandle(),(uint8_t *)&tripAverage,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = ((bd->getDataSet(BikeData::TRIP))->getTime());
        if (tmp != tripTime){
            tripTime = tmp;
            ble.gattServer().write(tripTimeChar.getValueHandle(),(uint8_t *)&tripTime,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        //OverallData
        tmp = (bd->getDataSet(BikeData::OVERALL))->getDistance()*100;
        if (tmp != overallDistance){
            overallDistance = tmp;
            ble.gattServer().write(overallDistanceChar.getValueHandle(),(uint8_t *)&overallDistance,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = (bd->getDataSet(BikeData::OVERALL))->getAverage()*100;
        if (tmp != overallAverage){
            overallAverage = tmp;
            ble.gattServer().write(overallAverageChar.getValueHandle(),(uint8_t *)&overallAverage,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = (bd->getDataSet(BikeData::OVERALL))->getTime();
        if (tmp != overallTime){
            overallTime = tmp;
            ble.gattServer().write(overallTimeChar.getValueHandle(),(uint8_t *)&overallTime,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        //Since Battery Change
        tmp = (bd->getDataSet(BikeData::BATCHANGE))->getDistance() *100;
        if (tmp != batChangeDistance){
            batChangeDistance = tmp;
            ble.gattServer().write(batChangeDistanceChar.getValueHandle(),(uint8_t *)&batChangeDistance,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = (bd->getDataSet(BikeData::BATCHANGE))->getAverage() *100;
        if (tmp != batChangeAverage){
            batChangeAverage = tmp;
            ble.gattServer().write(batChangeAverageChar.getValueHandle(),(uint8_t *)&batChangeAverage,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = (bd->getDataSet(BikeData::BATCHANGE))->getTime();
        if (tmp != batChangeTime){
            batChangeTime = tmp;
            ble.gattServer().write(batChangeTimeChar.getValueHandle(),(uint8_t *)&batChangeTime,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        // Continious Data
        tmp = bd->getLastCount();
        if (tmp != pulse){
            pulse = tmp;
            ble.gattServer().write(pulseChar.getValueHandle(),&pulse,sizeof(uint8_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = bd->getSpeed()*100;
        if (tmp != speed){
            speed = tmp;
            ble.gattServer().write(speedChar.getValueHandle(),(uint8_t *)&speed,sizeof(uint32_t));
            for (uint64_t i = 0; i<0x2760; i++);
            }
        tmp = bd->isLogging()*'5';
        if (tmp != control){
            control = tmp;
            ble.gattServer().write(controlChar.getValueHandle(),&control,sizeof(uint8_t));
            }
        }
 
public:

    //different variables for the service
    BLE                              &ble;
    BikeData                         *bd;
    uint32_t tripDistance, tripAverage, tripTime,
             overallDistance, overallAverage, overallTime,
             batChangeDistance, batChangeAverage, batChangeTime,
             speed;
    uint8_t pulse, control;
             
    //the different characteristics created of an template
    ReadOnlyGattCharacteristic<uint32_t>  tripDistanceChar;
    ReadOnlyGattCharacteristic<uint32_t>  tripAverageChar;
    ReadOnlyGattCharacteristic<uint32_t>  tripTimeChar;
    
    ReadOnlyGattCharacteristic<uint32_t>  overallDistanceChar;
    ReadOnlyGattCharacteristic<uint32_t>  overallAverageChar;
    ReadOnlyGattCharacteristic<uint32_t>  overallTimeChar;
    
    ReadOnlyGattCharacteristic<uint32_t>  batChangeDistanceChar;
    ReadOnlyGattCharacteristic<uint32_t>  batChangeAverageChar;
    ReadOnlyGattCharacteristic<uint32_t>  batChangeTimeChar;
    
    ReadOnlyGattCharacteristic<uint8_t>  pulseChar;
    ReadOnlyGattCharacteristic<uint32_t>  speedChar;
    ReadWriteGattCharacteristic<uint8_t>  controlChar;
    
    
    GattCharacteristic  *deviceNameChar;
};
 
#endif