/**
 *  \brief CS294-84 demo \author Ben Zhang, Antonio Iannopollo
 *
 * This sampel code illustrates how to connect the mbed KL25Z platform to internet
 * thorugh the CC3000 wifi breakout board (http://www.adafruit.com/product/1469).
 * Connections between the KL25Z and the CC3000 are made according to the
 * guide at https://learn.adafruit.com/adafruit-cc3000-wifi -- KL25Z and arduino
 * UNO are pin to pin compatible --
 *
 * This application uses the following libraries:
 * - cc3000_hostdriver_mbedsocket
 *   (http://developer.mbed.org/users/Kojto/code/cc3000_hostdriver_mbedsocket/)
 * - HTTPClient (http://developer.mbed.org/users/donatien/code/HTTPClient/)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "mbed.h"
#include "cc3000.h"
#include "HTTPClient.h"
#include "PinDetect.h"
#include "pwm_tone.h"

// KL25Z wifi connection
// we need to define connection pins for:
// - IRQ      => (pin D3)
// - Enable   => (pin D5)
// - SPI CS   => (pin D10)
// - SPI MOSI => (pin D11)
// - SPI MISO => (pin D12)
// - SPI CLK  => (pin D13)
// plus wifi network SSID, password, security level and smart-configuration flag.
mbed_cc3000::cc3000 wifi(D3, D5, D10, SPI(D11, D12, D13),
                         "Fire_2441", "", NONE, false);

// create an http instance
HTTPClient http;

// str is used to hold the response data
char str[512];
char url[128];
char in[512];
char out[512];


// setup the serial connection, and LEDs
Serial pc(USBTX, USBRX);
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

PinDetect p1(D4);
PinDetect p2(D6);
PinDetect p3(D7);
PinDetect reed(A3);
DigitalOut RGBindicator(D2);
DigitalOut Buzzer(D9);
DigitalOut warningLED(A4);
DigitalOut correctLED(A5);

int changedFromOFF = 0;
int changedFromON = 0;
int code[] = {0, 0, 0, 0};
int passwordcounter = 0;
bool codeEntered = false;
bool reedIsOpen = false;
bool alarmOn = false;
bool boxOpenLegal = false;
int password[] = {1, 1, 1, 1};
float C_3 = 1000000/Do3,
      Cs_3 = 1000000/Do3s,
      D_3 = 1000000/Re3,
      Ds_3 = 1000000/Re3s,
      E_3 = 1000000/Mi3,
      F_3 = 1000000/Fa3,
      Fs_3 = 1000000/Fa3s,
      G_3 = 1000000/So3,
      Gs_3 = 1000000/So3s,
      A_3 = 1000000/La3,
      As_3 = 1000000/La3s,
      B_3 = 1000000/Ti3,
      C_4 = 1000000/Do4,
      Cs_4 = 1000000/Do4s,
      D_4 = 1000000/Re4,
      Ds_4 = 1000000/Re4s,
      E_4 = 1000000/Mi4,
      F_4 = 1000000/Fa4,
      Fs_4 = 1000000/Fa4s,
      G_4 = 1000000/So4,
      Gs_4 = 1000000/So4s,
      A_4 = 1000000/La4,
      As_4 = 1000000/La4s,
      B_4 = 1000000/Ti4,
      C_5 = 1000000/Do5,
      Cs_5 = 1000000/Do5s,
      D_5 = 1000000/Re5,
      Ds_5 = 1000000/Re5s,
      E_5 = 1000000/Mi5,
      F_5 = 1000000/Fa5,
      Fs_5 = 1000000/Fa5s,
      G_5 = 1000000/So5,
      Gs_5 = 1000000/So5s,
      A_5 = 1000000/La5,
      As_5 = 1000000/La5s,
      B_5 = 1000000/Ti5;

int tones[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0,
               E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, E_4, D_4, C_4, 0, 0, 0
              };
int tones_num = 32;

//Queue buttonQ(4,4);

void key1Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 1;
    code[passwordcounter] = i;
    passwordcounter++;
    if (codeEntered==false){
        correctLED = 1;
    }
    //buttonQ.Put(&i);
}

void key1Released( void )
{
    //pc.printf("Key Released\n");
    if (codeEntered==false){
    correctLED = 0;
    }
}

void key1PressedHeld( void )
{
    //pc.printf("Key Pressed Held\n");
}

void key2Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 2;
    code[passwordcounter] = i;
    passwordcounter++;
    //buttonQ.Put(&i);
    if (codeEntered==false){
    correctLED = 1;
    }

}

void key2Released( void )
{
    //pc.printf("Key Released\n");
    if (codeEntered==false){
    correctLED = 0;
    }
}

void key2PressedHeld( void)
{
    //pc.printf("Key Pressed Held\n");
}

void key3Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 3;
    code[passwordcounter] = i;
    passwordcounter++;
    //buttonQ.Put(&i);
    if (codeEntered==false){
    correctLED = 1;
    }

}

void key3Released( void )
{
    //pc.printf("Key Released\n");
    if (codeEntered==false){
    correctLED = 0;
    }
}

void key3PressedHeld( void )
{
    //pc.printf("Key Pressed Held\n");
}

void reedOpen( void )
{
    pc.printf("Reed Open\r\n");
    pc.printf("boxOpenLegal: %d\r\n", boxOpenLegal);
    reedIsOpen = 1;
    if (!boxOpenLegal){
        Buzzer = 1;
        changedFromOFF = 1;
    }    
}

void reedClosed( void )
{
    pc.printf("Reed Closed\n");
    reedIsOpen = 0;
    if (boxOpenLegal==true){
        changedFromON = 1;
        correctLED =0;
        for (int j=0; j<8; j++){
            warningLED =1;
            wait(0.15);
            warningLED = 0;
            wait(0.15);
        }
        Buzzer = 0;
    }
    pc.printf("boxOpenLegal: %d\r\n", boxOpenLegal);
}

void reedOpenHeld( void )
{
    //pc.printf("Key Pressed Held\n");
    reedIsOpen = 1;
}

int main()
{
    // by default, it's red
    led_red = 0;
    led_green = 1;
    for (int j=0; j<4; j++){
        warningLED =1;
        wait(0.5);
        warningLED = 0;
        wait(0.5);
    }
    correctLED = 0;
    // print message to indicate the program has started
    pc.printf("CC3000 Lunch Theft\r\n");
    wifi.init();
    
    p1.mode(PullUp);
    p2.mode(PullUp);
    p3.mode(PullUp);
    reed.mode(PullUp);

    p1.attach_asserted( &key1Pressed);
    p1.attach_deasserted( &key1Released);
    p1.attach_asserted_held( &key1PressedHeld);
    p1.setAssertValue( 0 );
    p1.setSampleFrequency( 10000 );

    p2.attach_asserted( &key2Pressed);
    p2.attach_deasserted( &key2Released);
    p2.attach_asserted_held( &key2PressedHeld);
    p2.setAssertValue( 0 );
    p2.setSampleFrequency( 10000 );

    p3.attach_asserted( &key3Pressed);
    p3.attach_deasserted( &key3Released);
    p3.attach_asserted_held( &key3PressedHeld);
    p3.setAssertValue( 0 );
    p3.setSampleFrequency( 10000 );

    reed.attach_asserted( &reedClosed);
    reed.attach_deasserted( &reedOpen);
    reed.attach_deasserted_held( &reedOpenHeld);
    reed.setAssertValue( 0 );
    reed.setSampleFrequency( 10000 );
    
    Buzzer = 1;  //4 Octave C beat 4/16
    wait_ms(1000);
    Buzzer = 0;
    
    changedFromOFF = 0;
    changedFromON = 0;
    
    clock_t start_t, current_t, total_t;
    //int counterforpasswordcheck = 0;
    //int i;
    int init = 0; // init wifi done
    start_t = clock();
    int num = 0;                        
    reedIsOpen = (reed == 1);
    while (1) {
        pc.printf("reed value:%d\r\n",reedIsOpen);
        pc.printf("codeEntered:%d\r\n",codeEntered);
        pc.printf("boxOpenLegal:%d\r\n",boxOpenLegal);        
        
        if (init == 0) {
            if(wifi.is_connected() == false) {
                // try to connect
                if (wifi.connect() == -1) {
                    pc.printf("Failed to connect."
                              "Please verify connection details and try again.\r\n");
                } else {
                    pc.printf("IP address: %s \r\n", wifi.getIPAddress());

                    //once connected, turn green LED on and red LED off
                    led_red = 1;
                    led_green = 0;
                }
            } else {
                pc.printf("Test first\r\n");
                sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=NO&alarmOn=OFF&boxLocked=YES");
                int ret = http.get(url, str, 128);
                init = 1;
                int tries = 15;
                while (tries > 0) {
                    ret = http.get(url, str, 128);
                    if (!ret) {
                        pc.printf("Requested %s\r\n", url);
                        pc.printf("Page fetched successfully - read %d characters\r\n",
                                  strlen(str));
                        pc.printf("Result: %s\r\n", str);
                        break;
                    } else {
                        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                                  ret,
                                  http.getHTTPResponseCode());
                    }
                    tries--;
                }                
            }
        }
        current_t = clock();
        total_t = (double)(current_t - start_t) / (CLOCKS_PER_SEC);
        //pc.printf("total_t: %d\r\n", total_t);
        if ((total_t%1)==0){ //every t seconds
            pc.printf("SENDING TO URL\n");
                sprintf(url, "http://www.charlesding.net/kragl/pincode_read.php?");
                int ret = http.get(url, str, 128);
                pc.printf("Trying to Request %s\r\n", url);
                int tries = 50;
                while (tries > 0) { 
                    pc.printf("still in while lop #%d", tries);
                    if (!ret) {
                        pc.printf("Requested %s\r\n", url);
                        pc.printf("Page fetched successfully - read %d characters\r\n",
                                  strlen(str));
                        
                        char* s = strtok(str, "\n");
                        pc.printf("code string: %s\r\n",s);
                        if (true){
                            for (int c=1; c<5; c++){
                                char test[] = {s[c]};
                                num = atoi(test);
                                password[c-1] = num;    
                            }
                        }   
                        char test[] = {s[5]};
                        num = atoi(test);
                        pc.printf("Result last digit: %d\r\n", num);
                        if (num==1){
                            boxOpenLegal = true;
                            warningLED = 0;
                            for (int j=0; j<8; j++){
                                correctLED =1;
                                wait(0.15);
                                correctLED = 0;
                                wait(0.15);
                            }
                            Buzzer = 0;
                        } else {
                            boxOpenLegal = false;
                            if (reedIsOpen){
                                Buzzer = 1;
                            }
                            correctLED = 0;
                                for (int j=0; j<8; j++){
                                warningLED =1;
                                wait(0.15);
                                warningLED = 0;
                                wait(0.15);
                            }
                        }
                        break;
                    } else {
                        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                                  ret,
                                  http.getHTTPResponseCode());
                        
                    }
                    tries--;
                    ret = http.get(url, str, 128);
                }
            }
        //pc.printf("waiting to check...\r\n");
        //pc.printf("boxOpenLegal: %d\r\n", boxOpenLegal);
        //pc.printf("reedIsOpen: %d\r\n", reedIsOpen);
        if (!boxOpenLegal && reedIsOpen && codeEntered) {
            pc.printf("LEGAL OPENING");
            boxOpenLegal = true;
            codeEntered = false;
            Buzzer = 0;
            
            if (changedFromON){
            pc.printf("SENDING TO URL\n");
            sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=NO&alarmOn=OFF&boxLocked=YES");
            
            int ret = http.get(url, str, 128);
            pc.printf("Trying to Request %s\r\n", url);
            int tries = 20;
            while (tries > 0) {
                ret = http.get(url, str, 128);
                if (!ret) {
                    pc.printf("Requested %s\r\n", url);
                    pc.printf("Page fetched successfully - read %d characters\r\n",
                              strlen(str));
                    pc.printf("Result: %s\r\n", str);
                    break;
                } else {
                    pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                              ret,
                              http.getHTTPResponseCode());
                    tries--;
                }
            }
            changedFromON = 0;
            }
            
            
        } else if (reedIsOpen && !boxOpenLegal) {
            // turn on alarm;
            pc.printf("boxOpenLegal: %d\r\n", boxOpenLegal);
            pc.printf("reedIsOpen: %d\r\n", reedIsOpen);
            pc.printf("ALARM TIME\r\n");
            Buzzer = 1;

            if(wifi.is_connected() == false) {
                // try to connect
                if (wifi.connect() == -1) {
                    pc.printf("Failed to connect."
                              "Please verify connection details and try again.\r\n");
                } else {
                    pc.printf("IP address: %s \r\n", wifi.getIPAddress());

                    //once connected, turn green LED on and red LED off
                    led_red = 1;
                    led_green = 0;
                }
            } else {
                // get input url and then return the value
                if (changedFromOFF){
                pc.printf("SENDING TO URL\n");
                sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=YES1&alarmOn=ON&boxLocked=NO");

                int ret = http.get(url, str, 128);
                pc.printf("Trying to Request %s\r\n", url);
                int tries = 20;
                while (tries > 0) { 
                    if (!ret) {
                        pc.printf("Requested %s\r\n", url);
                        pc.printf("Page fetched successfully - read %d characters\r\n",
                                  strlen(str));
                        pc.printf("Result: %s\r\n", str);
                        break;
                    } else {
                        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                                  ret,
                                  http.getHTTPResponseCode());
                        tries--;
                    }
                    ret = http.get(url, str, 128);
                }
                changedFromOFF = 0;
                }
            }
            //wait(0.3);
        } else if (!reedIsOpen && boxOpenLegal) {
            Buzzer = 0;
            // boxOpenLegal = false;
            
            
            //wait(0.3);
        }
        if (!codeEntered && passwordcounter==sizeof(code)/4) {
            codeEntered = true;
           
            for (int j=0; j<sizeof(code)/4; j++) {
                if (code[j]!=password[j]) {
                    codeEntered = false;
                }
            }
            if (num==1){
                codeEntered = true;
            }
            if (codeEntered==true){
                Buzzer = 0;
                warningLED = 0;
                for (int j=0; j<8; j++){
                    correctLED =1;
                    wait(0.15);
                    correctLED = 0;
                    wait(0.15);
                }
            } else {
                correctLED = 0;
                for (int j=0; j<8; j++){
                    warningLED =1;
                    wait(0.15);
                    warningLED = 0;
                    wait(0.15);
                }
            }


            pc.printf("CODE IS ENTERED\n");
            passwordcounter = 0;

            pc.printf("SENDING TO URL\n");
            if (codeEntered==false){
            sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?alarmOn=OFF&authorized=NO&openLock=2");
            } else {
            sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?alarmOn=OFF&authorized=YES&openLock=1");
            }
            
            int ret = http.get(url, str, 128);
            pc.printf("Trying to Request %s\r\n", url);
            int tries = 50;
            while (tries > 0) {
                ret = http.get(url, str, 128);
                if (!ret) {
                    pc.printf("Requested %s\r\n", url);
                    pc.printf("Page fetched successfully - read %d characters\r\n",
                              strlen(str));
                    pc.printf("Result: %s\r\n", str);
                    break;
                } else {
                    pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                              ret,
                              http.getHTTPResponseCode());
                    tries--;
                }
            }


            }
            //counterforpasswordcheck++;
            //pc.printf("C%d ", counterforpasswordcheck);
        }
        
        

    

}
