/**
 *  \brief CS294-84 demo \author Ben Zhang, Antonio Iannopollo
 *
 * This sampel code illustrates how to connect the mbed KL25Z platform to internet
 * thorugh the CC3000 wifi breakout board (http://www.adafruit.com/product/1469).
 * Connections between the KL25Z and the CC3000 are made according to the
 * guide at https://learn.adafruit.com/adafruit-cc3000-wifi -- KL25Z and arduino
 * UNO are pin to pin compatible --
 *
 * This application uses the following libraries:
 * - cc3000_hostdriver_mbedsocket
 *   (http://developer.mbed.org/users/Kojto/code/cc3000_hostdriver_mbedsocket/)
 * - HTTPClient (http://developer.mbed.org/users/donatien/code/HTTPClient/)
 */

#include "mbed.h"
#include "cc3000.h"
#include "HTTPClient.h"
#include "PinDetect.h"
#include "pwm_tone.h"

// KL25Z wifi connection
// we need to define connection pins for:
// - IRQ      => (pin D3)
// - Enable   => (pin D5)
// - SPI CS   => (pin D10)
// - SPI MOSI => (pin D11)
// - SPI MISO => (pin D12)
// - SPI CLK  => (pin D13)
// plus wifi network SSID, password, security level and smart-configuration flag.
mbed_cc3000::cc3000 wifi(D3, D5, D10, SPI(D11, D12, D13),
                         "CalVisitor", "", NONE, false);

// create an http instance
HTTPClient http;

// str is used to hold the response data
char str[512];
char url[128];
char in[512];
char out[512];


// setup the serial connection, and LEDs
Serial pc(USBTX, USBRX);
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

PinDetect p1(D4);
PinDetect p2(D6);
PinDetect p3(D7);
PinDetect reed(D8);
PwmOut Buzzer(D9);

int code[] = {0, 0, 0, 0};
int passwordcounter = 0;
bool codeEntered = false;
bool reedIsOpen = false;
bool alarmOn = false;
bool boxOpenLegal = false;
int password[] = {3, 3, 1, 2};
float C_3 = 1000000/Do3,
      Cs_3 = 1000000/Do3s,
      D_3 = 1000000/Re3,
      Ds_3 = 1000000/Re3s,
      E_3 = 1000000/Mi3,
      F_3 = 1000000/Fa3,
      Fs_3 = 1000000/Fa3s,
      G_3 = 1000000/So3,
      Gs_3 = 1000000/So3s,
      A_3 = 1000000/La3,
      As_3 = 1000000/La3s,
      B_3 = 1000000/Ti3,
      C_4 = 1000000/Do4,
      Cs_4 = 1000000/Do4s,
      D_4 = 1000000/Re4,
      Ds_4 = 1000000/Re4s,
      E_4 = 1000000/Mi4,
      F_4 = 1000000/Fa4,
      Fs_4 = 1000000/Fa4s,
      G_4 = 1000000/So4,
      Gs_4 = 1000000/So4s,
      A_4 = 1000000/La4,
      As_4 = 1000000/La4s,
      B_4 = 1000000/Ti4,
      C_5 = 1000000/Do5,
      Cs_5 = 1000000/Do5s,
      D_5 = 1000000/Re5,
      Ds_5 = 1000000/Re5s,
      E_5 = 1000000/Mi5,
      F_5 = 1000000/Fa5,
      Fs_5 = 1000000/Fa5s,
      G_5 = 1000000/So5,
      Gs_5 = 1000000/So5s,
      A_5 = 1000000/La5,
      As_5 = 1000000/La5s,
      B_5 = 1000000/Ti5;

int tones[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0,
               E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, E_4, D_4, C_4, 0, 0, 0
              };
int tones_num = 32;

//Queue buttonQ(4,4);

void key1Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 1;
    code[passwordcounter] = i;
    passwordcounter++;
    //buttonQ.Put(&i);
}

void key1Released( void )
{
    //pc.printf("Key Released\n");
}

void key1PressedHeld( void )
{
    //pc.printf("Key Pressed Held\n");
}

void key2Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 2;
    code[passwordcounter] = i;
    passwordcounter++;
    //buttonQ.Put(&i);

}

void key2Released( void )
{
    //pc.printf("Key Released\n");
}

void key2PressedHeld( void)
{
    //pc.printf("Key Pressed Held\n");
}

void key3Pressed( void )
{
    //pc.printf("Key Pressed\n");
    int i = 3;
    code[passwordcounter] = i;
    passwordcounter++;
    //buttonQ.Put(&i);

}

void key3Released( void )
{
    //pc.printf("Key Released\n");
}

void key3PressedHeld( void )
{
    //pc.printf("Key Pressed Held\n");
}

void reedOpen( void )
{
    pc.printf("Reed Open\n");
    reedIsOpen = 1;

}

void reedClosed( void )
{
    pc.printf("Reed Closed\n");
    reedIsOpen = 0;
}

void reedOpenHeld( void )
{
    //pc.printf("Key Pressed Held\n");
}


int main()
{
    // by default, it's red
    led_red = 0;
    led_green = 1;

    // print message to indicate the program has started
    pc.printf("CC3000 Lunch Theft\r\n");
    wifi.init();

    p1.mode(PullUp);
    p2.mode(PullUp);
    p3.mode(PullUp);
    reed.mode(PullUp);

    p1.attach_asserted( &key1Pressed);
    p1.attach_deasserted( &key1Released);
    p1.attach_asserted_held( &key1PressedHeld);
    p1.setAssertValue( 0 );
    p1.setSampleFrequency( 10000 );

    p2.attach_asserted( &key2Pressed);
    p2.attach_deasserted( &key2Released);
    p2.attach_asserted_held( &key2PressedHeld);
    p2.setAssertValue( 0 );
    p2.setSampleFrequency( 10000 );

    p3.attach_asserted( &key3Pressed);
    p3.attach_deasserted( &key3Released);
    p3.attach_asserted_held( &key3PressedHeld);
    p3.setAssertValue( 0 );
    p3.setSampleFrequency( 10000 );

    reed.attach_asserted( &reedClosed);
    reed.attach_deasserted( &reedOpen);
    reed.attach_asserted_held( &reedOpenHeld);
    reed.setAssertValue( 0 );
    reed.setSampleFrequency( 10000 );

    Tune(Buzzer, C_4, 4);  //4 Octave C beat 4/16
    wait_ms(250);
    Tune(Buzzer, D_4, 4);  //4 Octave D beat 4/16
    wait_ms(250);
    Tune(Buzzer, E_4, 4);  //4 Octave E beat 4/16
    wait_ms(250);

    int i;
    int init = 0; // init wifi done


    while (1) {
        if (init == 0) {
            if(wifi.is_connected() == false) {
                // try to connect
                if (wifi.connect() == -1) {
                    pc.printf("Failed to connect."
                              "Please verify connection details and try again.\r\n");
                } else {
                    pc.printf("IP address: %s \r\n", wifi.getIPAddress());

                    //once connected, turn green LED on and red LED off
                    led_red = 1;
                    led_green = 0;
                }
            } else {
                sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=0&alarmOn=0");
                int ret = http.get(url, str, 128);
                init = 1;
                int tries = 5;
                while (ret && tries > 0) {
                    ret = http.get(url, str, 128);
                    if (!ret) {
                        pc.printf("Requested %s\r\n", url);
                        pc.printf("Page fetched successfully - read %d characters\r\n",
                                  strlen(str));
                        pc.printf("Result: %s\r\n", str);
                    } else {
                        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                                  ret,
                                  http.getHTTPResponseCode());
                    }
                    tries--;
                }

            }
        }

        if (reedIsOpen && codeEntered) {
            pc.printf("LEGAL OPENING");
            boxOpenLegal = true;
            codeEntered = false;
            wait(0.3);
        } else if (reedIsOpen && !boxOpenLegal) {
            // turn on alarm;
            pc.printf("ALARM TIME\n");
            for(i=0; i<tones_num; i++) {
                Auto_tunes(Buzzer, tones[i], 4); // Auto performance
                Stop_tunes(Buzzer);
            }
            boxOpenLegal = false;

            if(wifi.is_connected() == false) {
                // try to connect
                if (wifi.connect() == -1) {
                    pc.printf("Failed to connect."
                              "Please verify connection details and try again.\r\n");
                } else {
                    pc.printf("IP address: %s \r\n", wifi.getIPAddress());

                    //once connected, turn green LED on and red LED off
                    led_red = 1;
                    led_green = 0;
                }
            } else {
                // get input url and then return the value
                pc.printf("SENDING TO URL\n");
                sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=1&alarmOn=1");

                int ret = http.get(url, str, 128);
                pc.printf("Trying to Request %s\r\n", url);
                int tries = 5;
                while (ret && tries > 0) {
                    if (!ret) {
                        pc.printf("Requested %s\r\n", url);
                        pc.printf("Page fetched successfully - read %d characters\r\n",
                                  strlen(str));
                        pc.printf("Result: %s\r\n", str);
                    } else {
                        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                                  ret,
                                  http.getHTTPResponseCode());
                        tries--;
                    }
                }
            }


            wait(0.3);
        } else if (!reedIsOpen && boxOpenLegal) {
            boxOpenLegal = false;
            wait(0.3);
        }
        if (passwordcounter==sizeof(code)/4) {
            codeEntered = true;
            for (int j=0; j<sizeof(code)/4; j++) {
                if (code[j]!=password[j]) {
                    codeEntered = false;
                }
            }


            pc.printf("CODE IS ENTERED\n");
            passwordcounter = 0;

            pc.printf("SENDING TO URL\n");
            sprintf(url, "http://www.charlesding.net/kragl/lunchbox.php?isOpen=0&alarmOn=0");

            int ret = http.get(url, str, 128);
            pc.printf("Trying to Request %s\r\n", url);
            int tries = 5;
            while (ret && tries > 0) {
                if (!ret) {
                    pc.printf("Requested %s\r\n", url);
                    pc.printf("Page fetched successfully - read %d characters\r\n",
                              strlen(str));
                    pc.printf("Result: %s\r\n", str);
                } else {
                    pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                              ret,
                              http.getHTTPResponseCode());
                    tries--;
                }
            }


        }

    }

}
