#include "mbed.h"
#include "GT511C3.hpp"

Serial debug(USBTX,USBRX);

DigitalOut myled(LED1);
GT511C3 finger(p28,p27);

int progress(int status,char *msg)
{
    debug.printf("%s",msg);
    return 0;
}

int main() {
    int sts = 0;
    int ID = 0;

    debug.format(8,Serial::None,1);
    debug.baud(115200);

    debug.printf("Fingerprint reader module \"GT-511C3 / GT-511C31\" test program.\n");
    debug.printf("Build: %s %s\n",__DATE__,__TIME__);

    debug.printf("Open\n");
    sts = finger.Open();
    debug.printf("sts = %d\n",sts);
    if(sts == 0){
        int i;
        debug.printf("FirmwareVersion = %lx\n",finger.FirmwareVersion);
        debug.printf("IsoAreaMaxSize = %ld\n",finger.IsoAreaMaxSize);
        debug.printf("DeviceSerialNumber = ");
        for(i = 0; i < sizeof(finger.DeviceSerialNumber);i++){
            debug.printf("%02X",finger.DeviceSerialNumber[i]);
        }
        debug.printf("\n");
    }
    
    /* 
    STEPS:
    First configuration: enter a code to get ready to register fingerprint
    LED flashing/alarm buzzing to indicate start/finish of fingerprint
    When a finger is detected, matched with what is recorded, act similar to code
    */

    if(1){
        int EnrollID = 11;
        if(finger.CheckEnrolled(EnrollID) == 0){
            debug.printf("EnrollID(%d) is already enrolled.Delete!\n",EnrollID);
            if(finger.DeleteID(EnrollID) == 0){
                debug.printf("Delete OK!\n");
            }
        }
        finger.Enroll(EnrollID,progress);
    }

    finger.CmosLed(1);
    
    debug.printf("Press finger to identify\r\n");
    while(1) {
        if (finger.IsPress()){
            ID = finger.Identify();
            debug.printf("ID = %d\n",ID); 
            debug.printf("Remove finger\n");
        }
        finger.WaitPress(0);
        
    }
}
