/**
 * @file Disgruntled_Car.h
 *
 * @author Jaime Martinez
 * 
 * @section DESCRIPTION
 *
 * 
 */
#ifndef __DISGRUNTLED_CAR_H__
#define __DISGRUNTLED_CAR_H__
/**
 * Includes
 */
#include "mbed.h"
#include "arm_math.h"
#include "TFC.h"
#include "MMA8451Q.h"
 
 /**
 * Defines
 */
#define MMA_ADDR    0x1D
#define MMA_SCL     PTE24
#define MMA_SDA     PTE25
#define MMA_INT1    PTA14
#define MMA_INT2    PTA15
//more defines for the accelorometer registers

/**
 * disgruntledcar 
 */
class disgruntledcar {
public:

    disgruntledcar();

    void initServo(float SerPWMin, float SerPWMax, float SerPer);
    void initMotor(float SwFreq);

    bool getSwitch1();
    bool getSwitch2();
    bool getSwitch3();
    bool getSwitch4();

    bool getButtonA();
    bool getButtonB();

    float getPotentA();
    float getPotentB();

    float getBatteryVolt();

    bool getCamImage(float comcam0[], float comcam1[]);

    void setServoPos(float pos);

    void setMotorSpeed(float spda, float spdb);

    void setBatteryLED(uint8_t lvl);

    void setLED(uint8_t msk);

    float getAccX();
    float getAccY();
    float getAccZ();

    void getAccReg(int addr, uint8_t * data, int len);
    void setAccReg(uint8_t * data, int len);
    
    void conv(float a[], int lena, float b[], int lenb, float out[]);

private:

    MMA8451Q acc;

};

#endif /*__DISGRUNTLED_CAR_H__*/
