#include "Disgruntled_Car.h"
#include "TFC.h"
#include "mbed.h"

disgruntledcar::disgruntledcar() : acc(MMA_SDA, MMA_SCL, MMA_ADDR) {
    TFC_Init();
}

void disgruntledcar::initServo(float SerPWMin, float SerPWMax, float SerPer) {
    TFC_InitServos(SerPWMin, SerPWMax, SerPer);
}

void disgruntledcar::initMotor(float SwFreq) {
    TFC_InitMotorPWM(SwFreq);
}

bool disgruntledcar::getSwitch1() {
    return TFC_GetDIP_Switch()&0x01;
}

bool disgruntledcar::getSwitch2() {
    return (TFC_GetDIP_Switch()>>1)&0x01;
}

bool disgruntledcar::getSwitch3() {
    return (TFC_GetDIP_Switch()>>2)&0x01;
}

bool disgruntledcar::getSwitch4() {
    return (TFC_GetDIP_Switch()>>3)&0x01;
}

bool disgruntledcar::getButtonA() {
    return TFC_ReadPushButton(0);
}

bool disgruntledcar::getButtonB() {
    return TFC_ReadPushButton(1);
}

float disgruntledcar::getPotentA() {
    return TFC_ReadPot(0);
}

float disgruntledcar::getPotentB() {
    return TFC_ReadPot(1);
}

float disgruntledcar::getBatteryVolt() {
    return TFC_ReadBatteryVoltage();
}

bool disgruntledcar::getCamImage(float comcam0[], float comcam1[]) {
    if(TFC_LineScanImageReady>0){
        for(int i=0; i<128; i++){
            comcam0[i] = (float)(TFC_LineScanImage0[i]);
        }
        for(int i=0; i<128; i++){
            comcam1[i] = (float)(TFC_LineScanImage1[i]);
        }
        return true;
    }
    else{
        return false;
    }
}

void disgruntledcar::setServoPos(float pos) {
    TFC_SetServo(0, pos);
}

void disgruntledcar::setMotorSpeed(float spda, float spdb) {
    TFC_SetMotorPWM(spda, spdb);
}

void disgruntledcar::setBatteryLED(uint8_t lvl) {
    TFC_SetBatteryLED_Level(lvl);
}

void disgruntledcar::setLED(uint8_t msk) {
    TFC_SetBatteryLED(msk);
}

float disgruntledcar::getAccX() {
    return acc.getAccX();
}

float disgruntledcar::getAccY() {
    return acc.getAccY();
}

float disgruntledcar::getAccZ() {
    return acc.getAccZ();
}

void disgruntledcar::getAccReg(int addr, uint8_t * data, int len) {
    acc.readRegs(addr, data, len);
}

void disgruntledcar::setAccReg(uint8_t * data, int len) {
    acc.writeRegs(data, len);
}

void disgruntledcar::conv(float a[], int lena, float b[], int lenb, float out[]){
    int len = (2*lena)-1;
    float temp[len];
    arm_correlate_f32(a, lena, b, lenb, temp);
    for(int i = lenb-1; i<lena; i++){
        out[i-lenb-1] = temp[i];
    }
}
