#ifndef _MOTEUR_H
#define _MOTEUR_H

#include "mbed.h"
#include "Serie.h"
#include "Pid.h"


class Moteur
{
public:
    Moteur(PinName pin_pwm1, PinName pin_pwm2, PinName pin_feedback, PinName pin_capteur1, PinName pin_capteur2);
    void setVitesse(int v);
    void setKp(float k);
    void setKi(float k);
    void setKd(float k);
    void etalonnage();
    void test1();
    void test2();
    
    
    void setVitesse(float v);
    float getMesure();
    
protected:
    void setPuissance(float p);
    void asserv();
    void majErreur();
    void interruptCapteurRise();
    void interruptCapteurFall();
    void mesure();

    //IN-OUT
    AnalogIn feedbackCurrent;
    PwmOut m1;
    PwmOut m2;
    InterruptIn capteur1;
    DigitalIn capteur2;
    
    //MESURE
    Timer tmr;
    float derniere_mesure;
    
    //REGULATION
    Pid regulateur;
    Erreur erreur;
    float vitesse_consigne;
};

#endif