#include "Camera.h"


Camera::Camera(PinName pin_si, PinName pin_clk, PinName pin_ao, int periode_us) : ao(pin_ao),si(pin_si),clk(pin_clk) 
{
    this->periode = periode_us;
}

/*Quelques infos
Voir la doc de la cam
On genere une impulsion sur SI pour terminer l'acquisition en cours et signaler que l'on va lire les valeurs des pixels
La valeur d'un pixel est mis analogiquement sur AO apres chaque front montant d'horloge
SI et clk sont en quadratures de phase
Le temps d'intégration est le temps entre la lecture du 28 eme pixel et le prochain signal SI*/
void Camera::capture(unsigned short *valeurs)
{
    //ENVOI DU SIGNAL DE START SUR SI(QUADRATURE DE PHASE AVEC CLK)
    this->si.write(1);
    wait_us(this->periode);
    this->clk.write(1);
    wait_us(this->periode);
    this->si.write(0);
    wait_us(this->periode);
    this->ao.read_u16();
    this->clk.write(0);

    //RECUPERATION DES DONNEES
    wait_us(this->periode);
    for (int i = 0; i < 128; i++)
    {
        wait_us(this->periode);
        wait_us(this->periode);
        this->clk.write(1);
        wait_us(this->periode);
        wait_us(this->periode);
        //this->ao.read(); pour avoir des flottants sur [0;1]
        valeurs[i] = this->ao.read_u16();
        this->clk.write(0);   
    }
    
    //PROCEDURE DE TERMINAISON
    wait_us(this->periode);
    wait_us(this->periode);
    this->clk.write(1);
    wait_us(this->periode);
    wait_us(this->periode);
    this->clk.write(0);

}

void Camera::setPeriod(int periode)
{
    this->periode = periode;
}