#include "mbed.h"
#include "FT_Platform.h"
#include "FT_color.h"
#include "stdio.h"
#include "float.h"
#include "SDFileSystem.h"

#define SAMAPP_DELAY_BTW_APIS (1000)
#define SAMAPP_ENABLE_DELAY() Ft_Gpu_Hal_Sleep(SAMAPP_DELAY_BTW_APIS)
#define SAMAPP_ENABLE_DELAY_VALUE(x) Ft_Gpu_Hal_Sleep(x)

FT800 TFT(D11,D12,D13,D9,D8,D14);
SDFileSystem sd(D11, D12, D13, D10, "sd");

// global Vars
unsigned int r, b, g;
char buffer[50];

/* function to load jpg file from internal filesystem */
/* into FT800 buffer and decode JPG to bitmap         */        
/* return 0 if jpg is ok                              */
/* return x_size and y_size of jpg                    */

int main()
{
    ft_int16_t x_size,y_size;

    TFT.MemWrite(REG_ROTATE,1);
    TFT.Rotate(1);
    //TFT.Calibrate();                               // calibrate the touch screen
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255,255,255));
    TFT.DL(CLEAR(1,1,1));
    
    TFT.DL(BITMAP_HANDLE(0));
    TFT.Load_jpg("/sd/Logo.jpg",& x_size,& y_size, 0);  
    
    TFT.DL(DISPLAY());                     // Display the image
    TFT.Swap();                            // Swap the current display list
    TFT.Flush_Co_Buffer();                 // Download the command list into fifo
    TFT.WaitCmdfifo_empty(); 

    TFT.Track(225, 375, 350, 30, 1);
    TFT.Flush_Co_Buffer();                         // Download the commands into fifo
    TFT.WaitCmdfifo_empty();                       // Wait till coprocessor completes the operation
    while(1) {
        TFT.DLstart();
        TFT.DL(CLEAR_COLOR_RGB(255,255,255));
        TFT.DL(CLEAR(1,1,1));
        TFT.DL(BEGIN(BITMAPS));
        TFT.DL(VERTEX2II(512,50,0,0));          //Write logo (bitmap handle 0) to pixel 512
        TFT.DL(VERTEX_TRANSLATE_X(50*16));      //Translate by 50 pixels
        TFT.DL(VERTEX2II(511,200,0,0));         //Write logo
        TFT.DL(VERTEX_TRANSLATE_X(0*16));       //Translate back
        TFT.DL(DISPLAY());                      // Display the image
        TFT.Swap();                                            // Swap the current display list
        TFT.Flush_Co_Buffer();                                 // Download the command list into fifo
        TFT.WaitCmdfifo_empty();                               // Wait till coprocessor completes the operation
        
        
        
        
        
        /*ft_uint8_t tagval = 0;
        TrackRegisterVal = TFT.Rd32(REG_TRACKER);    // check if one of the two tracking fields is touched
        tagval = TrackRegisterVal & 0xff; 
        
        
        TFT.DL(COLOR_RGB(0x00,0x7C,0xC4));
        TFT.Text(265, 200, 31, 0, "ITV 1 Pressure");
        TFT.DL(BEGIN(RECTS));
        TFT.DL(VERTEX2F(300*16,265*16));
        TFT.DL(VERTEX2F(505*16,330*16));
        TFT.DL(END());
        TFT.DL(COLOR_RGB(255,255,255));
        sprintf(buffer, "%.1f", ITVpressure1_feedback);
        TFT.Text(325,275,31,0,buffer);
        TFT.Text(415, 275, 31, 0, " PSI");
        ITVpressure1_feedback =  0;
        TFT.DL(COLOR_RGB(255,255,255));
 
        TFT.FgColor(COLOR_RGB(0,124,196));
        TFT.BgColor(COLOR_RGB(0,124,196));
        TFT.DL(TAG(1));                        // assign TAG value 1
        TFT.Slider(225,375,350,30,0,ITVpressure1_user_input,65535);*/

        
    }
}



