#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS

Serial pc(USBTX, USBRX);

FILE *Data;   // Creates name of file
char buffer[1024];  // Buffer size (# of characters)

int main() {
    pc.printf("Initializing \n");
    
    float x = 214;
    double y = 200;
    
    Data = fopen("/sd/Data.txt", "r");   // Opens file if it exists, r means read
    if (Data != NULL) remove("/sd/Data.txt"); // If it does close it then remove it
    fclose(Data); 
    
    Data = fopen("/sd/Data.txt", "w"); // w means write
    for(int i=0; i<4; i++){
        if (Data == NULL) pc.printf("Unable to write the file \n\r");  // This chunk for writing to file on SD card
        else fprintf(Data, "%f\t%f\n",x,y);  // can read float or double not int (only checked these three types)
        x++;
        y--;
    }
    fclose(Data);
    
    Data = fopen("/sd/Data.txt", "r");
    if (Data != NULL) {
        int size = fread(buffer, sizeof(char), 1024, Data); // This chunk for reading the file on the SD card
        printf("%s\n", buffer); // can read float or double not int (only checked these three types)
    }
    fclose(Data);
}
