#include "mbed.h"
#include "FXOS8700CQ.h"
 
Serial pc(USBTX, USBRX); // Primary output to demonstrate library
 
FXOS8700CQ fxos(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // SDA, SCL, (addr << 1)
 
DigitalOut green(LED_GREEN); // waiting light
DigitalOut blue(LED_BLUE); // collection-in-progress light
DigitalOut red(LED_RED); // completed/error ligt
 
Timer t; // Microsecond timer, 32 bit int, maximum count of ~30 minutes
InterruptIn fxos_int2(PTC13); // should just be the Data-Ready interrupt
bool fxos_int2_triggered = false; // Interrupt status flags and data
 
SRAWDATA accel_data; // Storage for the data from the sensor
SRAWDATA magn_data;
 
void trigger_fxos_int2(void){
    fxos_int2_triggered = true;
}
 
void print_reading(){
    pc.printf("A X:%5d,Y:%5d,Z:%5d   M X:%5d,Y:%5d,Z:%5d\r\n",
              accel_data.x, accel_data.y, accel_data.z,
              magn_data.x, magn_data.y, magn_data.z);
}
 
int main(void){
    t.reset();
    pc.baud(115200); // 200Hz x line of output data!
    
    green.write(1);
    red.write(1);
    blue.write(1);
 
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", fxos.get_whoami());
     
    fxos_int2.fall(&trigger_fxos_int2); // Iterrupt for active-low interrupt line from FXOS
    fxos.enable();
 
    green.write(0); // ready-green on
 
    // Example data printing
    fxos.get_data(&accel_data, &magn_data);
    print_reading();
 
    pc.printf("Started data collection. Accelerometer at max %dg.\r\n",
    fxos.get_accel_scale());
 
    fxos.get_data(&accel_data, &magn_data); // clear interrupt from device
    fxos_int2_triggered = false; // un-trigger
 
    t.start(); // start timer and enter collection loop
    while(1){
       if(fxos_int2_triggered) {
           fxos_int2_triggered = false; // un-trigger
           fxos.get_data(&accel_data, &magn_data);
           print_reading(); // outpouring of data !!
        }
 
        // Continuous polling of interrupt status is not efficient, but...
        wait_us(500); // 1/10th the period of the 200Hz sample rate
    }
}