#ifndef SCANNER_H
#define SCANNER_H
#include "mbed.h"
#include "LongRangeSensor.h"
#include "ShortRangeSensor.h"
#include "StepperDrive.h"
#include "Gripper.h"
#include <stack>

class Scanner
{
public:
    Scanner(Serial &pc1, StepperDrive &_drive, PinName _servoL, PinName _servoR,
        ShortRangeSensor &_shortRangeL, ShortRangeSensor &_shortRangeR, 
        LongRangeSensor &_longRangeL, LongRangeSensor &_longRangeR,
        Gripper &_robotGrip, float _period = 0.2, ColorSensor colorSensor);
    void huntMode();
    void hunt();
    void avoidMode();
    void localize();
    void localizeRight();
    void localizeLeft();
    void localizeRightMode();
    void localizeLeftMode();
    float getDistLeft() {return distLeft;}
    float getDistRight() {return distRight;}
    float getDistForwardL() {return distForwardL;}
    float getDistForwardR() {return distForwardR;}
    void setLocalizeRightFlag(bool value) {localizeRightFlag = value;}
    void setLocalizeLeftFlag(bool value) {localizeLeftFlag = value;}
    bool getYellowFlag() {return yellowFlag;}
    bool getObjectFound() {return objectFound;}

private:
    static const int YELLOW = 1;
    static const int RED = 0;
    static const int MIN_DUTY = 0;
    static const int MAX_DUTY = 6;
    static const int HALF_DUTY = 3;
    static const float DELTA_DUTY = 4.2e-3;
    float DUTY[13]; // {0.0500, 0.0542, 0.0583, 0.0625, 0.0667, 0.0708,
                    // 0.0750, 0.0792, 0.0833, 0.0875, 0.0917, 0.0958,
                    // 0.1000};
    bool pitEnable;
    int invertL;
    int invertR;
    int dutyL;
    int dutyR;
    float distLeft;
    float distRight;
    float distForwardL;
    float distForwardR;
    Serial &pc;
    StepperDrive &drive;
    PwmOut servoL;
    PwmOut servoR;
    ShortRangeSensor &shortRangeL;
    ShortRangeSensor &shortRangeR;
    LongRangeSensor &longRangeL;
    LongRangeSensor &longRangeR;
    Gripper &robotGrip;
    float period;
    bool obstacle;
    bool huntFlag;
    bool avoidFlag; 
    bool objectFound;
    bool localizeRightFlag;
    bool localizeLeftFlag;
    bool yellowFlag;
    
    struct huntMove
    {
        float distance;
        float angle;
    };

    Ticker scanPit; // periodic interrupt timer

    void scan();

    std::stack<huntMove> myStack;
};

#endif // SCANNER_H
