#include "mbed.h"
#include <cmath> // pow

Serial pc(USBTX, USBRX);

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
AnalogIn sensor1(PTB2);
AnalogIn sensor2(PTB3);
float dist;

//float getDist(AnalogIn& sensor);
float distAdjL(double sensor_read);
float distAdjR(double sensor_read);

int main() 
{
    pc.baud(115200);
    
    float percent1 = 0.0;
    float voltage1 = 0.0;
    float percent2 = 0.0;
    float voltage2 = 0.0;
    int count;
    char choice;
    
    pc.printf("Enter 'c' for calibration mode or 't' for testing mode.\n");
    pc.printf("Press 'e' to exit.\n");
    choice = pc.getc();
    
    switch(choice)
    {
        case 'C':
        case 'c':    
            count = 5;
            led_red = 0;
            led_green = 1;
            pc.printf("\nMove target to listed distance and press space bar to measure\n");
            pc.printf("Press 'e' to exit.\n");
        
            pc.printf("\nDist  Perc1    Volt1    Perc2    Volt2");
            pc.printf("\n%*i", 4, count);
            choice = pc.getc();
            
            while(choice != 'q')
            {   
                led_red = 0;
                led_green = 1;
                for(int i = 0; i < 250; i++)
                {
                    percent1 += sensor1.read();
                    voltage1 += 3.3 * sensor1.read();
                    percent2 += sensor2.read();
                    voltage2 += 3.3 * sensor2.read();
                    wait(32e-3);
                }
                
                pc.printf(" %f %f %f %f", percent1/250.0, voltage1/250.0, percent2/250.0, voltage2/250.0 );
                percent1 = 0.0;
                voltage1 = 0.0;
                percent2 = 0.0;
                voltage2 = 0.0;
                count++;
                led_red = 1;
                led_green = 0;
                
                pc.printf("\n%*i", 4, count);
                choice = pc.getc();
            }
            break;
        
        case 'T':
        case 't':
            count = 5;
            pc.printf("\nMove target to distance and press space bar to measure\n");
            pc.printf("Press 'e' to exit.\n");
            
            pc.printf("\nDist  Meas1    AdjM1    Meas2    AdjM2");
            pc.printf("\n%*i", 4, count + 10);
            choice = pc.getc();
            
            while(choice != 'q')
            {
                led_red = 0;
                led_green = 1;
                for(int i = 0; i < 50; i++)
                {
                    percent1 += sensor1.read();
                    percent2 += sensor2.read();
                    wait(32e-3);
                }
                
                pc.printf(" %f %f %f %f", 3.5097*pow((percent1/50.0), -1.425), distAdjL(percent1/50.0), 3.4617*pow((percent2/50.0), -1.506), distAdjR(percent2/50.0) );
                percent1 = 0.0;
                percent2 = 0.0;
                count++;
                led_red = 1;
                led_green = 0; 
                
                pc.printf("\n%*i", 4, count);
                choice = pc.getc();              
            }
            break;
        
        case 'Q':
        case 'q':
            break;
        
        default:
            pc.printf("\nInvalid entry. You're fired.");
    }
}

float distAdjL(double sensor_read)
{
    double dist_meas = 3.5097*pow(sensor_read, -1.425);
    
    double read_error = (0.0052*pow(dist_meas, 2.0)) - (0.3218*dist_meas) 
                + 2.6653;
    
    return float(dist_meas + read_error);
}

float distAdjR(double sensor_read)
{
    double dist_meas = 3.4617*pow(sensor_read, -1.506);
    
    double read_error = (0.0062*pow(dist_meas, 2.0)) - (0.385*dist_meas)
                + 3.1692;
                
    return float(dist_meas + read_error);
}