/*This piece of code sets a threshold and reads all the sensors
**sample output:
**
**Please put all the sensors over white and press <enter>
**
**The values of the line sensors are below
**0 == white  1 == black
**
**1 2 3 4 5 6 7 8
**0 0 0 1 1 0 0 0
*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
Timer timer;
DigitalInOut sens[8] = {PTB8, PTB9, PTB10, PTB11, PTE2, PTE3, PTE4, PTE5};    //freedom board pins
int detect[8];

void readLine(int);
int setThresh(int);

int main() {
    int thresh;
    int timeOut = 0x7FFFFFFF;
     
    pc.printf("Please put all the sensors over white and press <enter>\n\n\r");
    pc.getc();
    
    thresh = setThresh(timeOut);
    
    timeOut = 2 * thresh;
    
    pc.printf("The values of the line sensors are below\n\r0 == white  1 == black\n\n\r");
    pc.printf("1 2 3 4 5 6 7 8\n\r");
    
    while(1){
        readLine(timeOut);
        
        for(int i = 0; i < 8; i++){
            if(detect[i] > thresh)
                detect[i] = 1;
            else
                detect[i] = 0;
            
            pc.printf("%u ", detect[i]);
        }
        pc.printf("\r");
        wait_ms(50);
    }
}

void readLine(int timeOut){    
    for(int i = 0; i < 8; i++){
        sens[i].output(); 
        sens[i] = 1;
        wait_us(15);
        sens[i] = 0;
        sens[i].input();
        timer.start();
        while(sens[i] == 1 && timer.read_us() < timeOut){
        }
        timer.stop();
        detect[i] = timer.read_us();
        timer.reset();
    }
}

int setThresh(int timeOut){
    long int temp = 0;
    
    readLine(timeOut);
    for(int i = 0; i < 8; i++){
        temp += detect[i];
    }
    return 9 * (temp / 8.0);
}