/*This piece of code polls a single "line sensor"
**to see if it is over a dark or light surface and sends either 
**"Black" or "White" through the(USB)serial port or it sends the discharge
**time (in microseconds) of the capacitor. The threshold 
**value has to be determined experimentally. It is the time delay
**over which a surface is considered "Black".
**
**
**To enable raw data to be sent to the serial port:
**uncomment lines   41-52
**comment lines     23-39*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
Timer timer;
DigitalInOut sens(PTB8);    //freedom board pin number

int readLine(int);
void setThresh(int&);

int main() {
    int thresh;
    
    pc.printf("Please put the sensor over white and press <enter>\n\r");
    pc.getc();
    
    setThresh(thresh);
    
    pc.printf("The surface is:\n\r");
    
    while(1){
        if (readLine(thresh) > thresh)
            pc.printf("Black\r");
        else
            pc.printf("White\r");
        
        wait_ms(200);
    }

/*    int count = 0;

    pc.printf("The sensor value is:\n\r");

    while(1){        
        count = readLine(0x7A120);
        
        pc.printf("               \r");        
        pc.printf("%d\r",count);
            
        wait_ms(200);
    }*/
}

int readLine(int timeOut = 0x7A120){
    timer.reset();
    
    sens.output(); 
    sens = 1;
    wait_us(15);
    sens = 0;
    sens.input();
    timer.start();
    while(sens == 1 && timer.read_us() < (2 * timeOut)){
    }
    
    timer.stop();
    return timer.read_us();
}

void setThresh(int& thresh){
    thresh = readLine() * 9;
}