#include "mbed.h"
#include "TFC.h"

bool isValid(float);

Serial pc(USBTX, USBRX);

int main(){
    float pos = 0;
    int deg = 0;
    uint8_t servo = 0;
    
    TFC_Init();
    
    pc.printf("Please enter a posiiton for your servo (-1.0-1.0)\r\n");
    
    while(1){
        pc.scanf("%f", &pos);
        
        if(isValid(pos)){
            deg = pos * 90;
            pc.printf("Your servo is at position %1.3f or %2i degrees  \r", pos, deg);
            TFC_SetServo(servo, pos);
        }
        else{
            pc.printf("Sorry, invalid command.                         \r");
            pos = 0;
            TFC_SetServo(servo, pos);
        }
        wait_ms(500);
    }
}

bool isValid(float pos){\
    if (pos <= 1.0f && pos >= -1.0f)
        return true;
    else
        return false;
}