#include "mbed.h"
#include "ShortRangeSensor.h"

int main()
{
    ShortRangeSensor srs(PTC11, PTC10);
    Serial pc(USBTX, USBRX);
    
    pc.printf("Part to Part Offset = %X\r\n\n", srs.getPPOffset());
    srs.setPPOffset(32);
    pc.printf("Part to Part Offset = %X\r\n\n", srs.getPPOffset());
    
    while(true)
    {
        pc.printf("%i mm   %X\n\r", srs.getRange(), srs.getStatus());
        wait(3);
    }
    
    return 0;
}